/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.collections.list.UnmodifiableList;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IContentOutputHandler;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoPublisher;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISessionStartupAction;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.engine.ISystemSettings;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PentahoSystemException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.PentahoSessionParameterProvider;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.SimpleMapCacheManager;
import org.pentaho.platform.engine.core.system.StandaloneApplicationContext;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PentahoSystem {
    public static final boolean debug = true;
    public static final boolean trace = false;
    public static final boolean ignored = false;
    public static int loggingLevel = 5;
    private static IApplicationContext applicationContext;
    protected static final String CONTENT_REPOSITORY = "IContentRepository";
    protected static final String RUNTIME_REPOSITORY = "IRuntimeRepository";
    private static final String SOLUTION_REPOSITORY = "ISolutionRepository";
    protected static final String SOLUTION_ENGINE = "ISolutionEngine";
    public static final String BACKGROUND_EXECUTION = "IBackgroundExecution";
    public static final String CONDITIONAL_EXECUTION = "IConditionalExecution";
    public static String DEFAULT_CONDITIONAL_EXECUTION_PROVIDER;
    public static String DEFAULT_MESSAGE_FORMATTER;
    public static String DEFAULT_NAVIGATION_COMPONENT;
    public static final String SCHEDULER = "IScheduler";
    public static final String MESSAGE_FORMATTER = "IMessageFormatter";
    public static final String NAVIGATION_COMPONENT = "INavigationComponent";
    public static final String SCOPE_GLOBAL = "global";
    public static final String SCOPE_SESSION = "session";
    public static final String SCOPE_LOCAL = "local";
    public static final String SCOPE = "scope";
    public static final String PENTAHO_SESSION_KEY = "pentaho-session-context";
    private static Map globalAttributes;
    private static SimpleParameterProvider globalParameters;
    private static ISystemSettings systemSettingsService;
    private static List<IPentahoPublisher> administrationPlugins;
    private static List<IPentahoSystemListener> listeners;
    private static List<ISessionStartupAction> sessionStartupActions;
    private static IPentahoObjectFactory pentahoObjectFactory;
    private static final Map initializationFailureDetailsMap;
    private static final List<String> RequiredObjects;
    private static final List<String> KnownOptionalObjects;
    private static final List<String> IgnoredObjects;
    public static final int SYSTEM_NOT_INITIALIZED = -1;
    public static final int SYSTEM_INITIALIZED_OK = 0;
    public static final int SYSTEM_LISTENERS_FAILED;
    public static final int SYSTEM_OBJECTS_FAILED;
    public static final int SYSTEM_PUBLISHERS_FAILED;
    public static final int SYSTEM_AUDIT_FAILED;
    public static final int SYSTEM_PENTAHOXML_FAILED;
    public static final int SYSTEM_SETTINGS_FAILED;
    public static final int SYSTEM_OTHER_FAILED;
    private static int initializedStatus;
    private static final String SUBSCRIPTION_REPOSITORY = "ISubscriptionRepository";
    private static final String SUBSCRIPTION_SCHEDULER = "ISubscriptionScheduler";
    private static final String USERSETTING_SERVICE = "IUserSettingService";
    private static final String ACL_VOTER = "IAclVoter";
    private static final String CACHE_MANAGER = "ICacheManager";
    private static IUserDetailsRoleListService userDetailsRoleListService;
    private static final List ACLFileExtensionList;
    private static final List UnmodifiableACLFileExtensionList;
    private static final List logoutListeners;

    public static boolean init() {
        return PentahoSystem.init(new StandaloneApplicationContext(".", "."));
    }

    public static boolean init(IApplicationContext pApplicationContext) {
        return PentahoSystem.init(pApplicationContext, null);
    }

    public static boolean init(IApplicationContext pApplicationContext, Map listenerMap) {
        Logger.debug(PentahoSystem.class, (String)"PentahoSystem init start");
        initializedStatus = 0;
        globalAttributes = Collections.synchronizedMap(new HashMap());
        globalParameters = new SimpleParameterProvider(globalAttributes);
        applicationContext = pApplicationContext;
        Logger.debug(PentahoSystem.class, (String)"Setting property path");
        String propertyPath = applicationContext.getSolutionPath("");
        propertyPath = propertyPath.replaceAll("\\\\", "/");
        System.setProperty("pentaho.solutionpath", propertyPath);
        if (LocaleHelper.getLocale() == null) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        if (systemSettingsService != null) {
            Logger.debug(PentahoSystem.class, (String)"Reading ACL list from pentaho.xml");
            String aclFiles = PentahoSystem.getSystemSetting("acl-files", "xaction,url");
            StringTokenizer st = new StringTokenizer(aclFiles, ",");
            while (st.hasMoreElements()) {
                String extn = st.nextToken();
                if (!extn.startsWith(".")) {
                    extn = "." + extn;
                }
                ACLFileExtensionList.add(extn);
            }
        }
        Logger.debug(PentahoSystem.class, (String)"Initialize XML Factories");
        PentahoSystem.initXMLFactories();
        Logger.debug(PentahoSystem.class, (String)"Set Logging Level from pentaho.xml setting");
        loggingLevel = 5;
        if (systemSettingsService != null) {
            loggingLevel = Logger.getLogLevel((String)systemSettingsService.getSystemSetting("log-level", "ERROR"));
        }
        Logger.setLogLevel((int)loggingLevel);
        Logger.debug(PentahoSystem.class, (String)"Register host name verifier");
        PentahoSystem.registerHostnameVerifier();
        assert (null != pentahoObjectFactory) : "pentahoObjectFactory must be non-null";
        try {
            Logger.debug(PentahoSystem.class, (String)"Validating object factory");
            PentahoSystem.validateObjectFactory();
        }
        catch (PentahoSystemException e1) {
            throw new RuntimeException(e1);
        }
        try {
            Logger.debug(PentahoSystem.class, (String)"Start System Listeners");
            PentahoSystem.notifySystemListenersOfStartup();
        }
        catch (PentahoSystemException e) {
            String msg = e.getLocalizedMessage();
            Logger.error((String)PentahoSystem.class.getName(), (String)msg, (Throwable)e);
            initializedStatus |= SYSTEM_LISTENERS_FAILED;
            PentahoSystem.addInitializationFailureMessage(SYSTEM_LISTENERS_FAILED, msg);
            return false;
        }
        Logger.debug(PentahoSystem.class, (String)"Global startup");
        PentahoSystem.globalStartup();
        Logger.debug(PentahoSystem.class, (String)"PentahoSystem Init Complete");
        return true;
    }

    private static void notifySystemListenersOfStartup() throws PentahoSystemException {
        if (listeners == null || listeners.size() == 0) {
            return;
        }
        IPentahoSession session = null;
        try {
            session = (IPentahoSession)pentahoObjectFactory.get(IPentahoSession.class, "systemStartupSession", null);
            PentahoSessionHolder.setSession(session);
            PentahoSystem.notifySystemListenersOfStartup(session);
        }
        catch (ObjectFactoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static void notifySystemListenersOfStartup(IPentahoSession session) throws PentahoSystemException {
        if (listeners != null && listeners.size() > 0) {
            for (IPentahoSystemListener systemListener : listeners) {
                PentahoSystem.systemEntryPoint();
                try {
                    Logger.debug(PentahoSystem.class, (String)("System Listener Start: " + systemListener.getClass().getName()));
                    if (!systemListener.startup(session)) {
                        throw new PentahoSystemException(Messages.getErrorString("PentahoSystem.ERROR_0014_STARTUP_FAILURE", systemListener.getClass().getName()));
                    }
                    Logger.debug(PentahoSystem.class, (String)("System Listener Complete: " + systemListener.getClass().getName()));
                }
                catch (Throwable e) {
                    throw new PentahoSystemException(Messages.getErrorString("PentahoSystem.ERROR_0014_STARTUP_FAILURE", systemListener.getClass().getName()), e);
                }
                finally {
                    PentahoSystem.systemExitPoint();
                }
            }
        }
    }

    private static void initXMLFactories() {
        String xpathToXMLFactoryNodes;
        List nds;
        if (systemSettingsService != null && null != (nds = systemSettingsService.getSystemSettings(xpathToXMLFactoryNodes = "xml-factories/factory-impl"))) {
            for (Node nd : nds) {
                Node nameAttr = nd.selectSingleNode("@name");
                Node implAttr = nd.selectSingleNode("@implementation");
                if (null != nameAttr && null != implAttr) {
                    String name = nameAttr.getText();
                    String impl = implAttr.getText();
                    System.setProperty(name, impl);
                    continue;
                }
                Logger.error((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0025_LOAD_XML_FACTORY_PROPERTIES_FAILED", xpathToXMLFactoryNodes));
            }
        }
    }

    public static boolean getInitializedOK() {
        return initializedStatus == 0;
    }

    public static int getInitializedStatus() {
        return initializedStatus;
    }

    private static List getAdditionalInitializationFailureMessages(int failureBit) {
        List l = (List)initializationFailureDetailsMap.get(new Integer(failureBit));
        return l;
    }

    public static List getInitializationFailureMessages() {
        List l;
        ArrayList<String> rtn = new ArrayList<String>();
        if (PentahoSystem.hasFailed(SYSTEM_SETTINGS_FAILED)) {
            rtn.add(Messages.getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_SETTINGS_FAILED", "PENTAHO_SYS_CFG_PATH"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_SETTINGS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_PUBLISHERS_FAILED)) {
            rtn.add(Messages.getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_PUBLISHERS_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_PUBLISHERS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_OBJECTS_FAILED)) {
            rtn.add(Messages.getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_OBJECTS_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_OBJECTS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_AUDIT_FAILED)) {
            rtn.add(Messages.getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_AUDIT_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_AUDIT_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_LISTENERS_FAILED)) {
            rtn.add(Messages.getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_LISTENERS_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_LISTENERS_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_PENTAHOXML_FAILED)) {
            rtn.add(Messages.getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_PENTAHOXML_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_PENTAHOXML_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        if (PentahoSystem.hasFailed(SYSTEM_OTHER_FAILED)) {
            rtn.add(Messages.getString("PentahoSystem.USER_INITIALIZATION_SYSTEM_OTHER_FAILED"));
            l = PentahoSystem.getAdditionalInitializationFailureMessages(SYSTEM_OTHER_FAILED);
            if (l != null) {
                rtn.addAll(l);
            }
        }
        return rtn;
    }

    public static void addInitializationFailureMessage(int failureBit, String message) {
        String msg;
        Integer i = new Integer(failureBit);
        List<String> l = (List<String>)initializationFailureDetailsMap.get(i);
        if (l == null) {
            l = Collections.synchronizedList(new ArrayList());
            initializationFailureDetailsMap.put(i, l);
        }
        if (!l.contains(msg = "&nbsp;&nbsp;&nbsp;" + message)) {
            l.add(msg);
        }
    }

    private static final boolean hasFailed(int errorToCheck) {
        return (initializedStatus & errorToCheck) == errorToCheck;
    }

    public static IContentOutputHandler getOutputDestinationFromContentRef(String contentTag, IPentahoSession session) {
        int pos = contentTag.indexOf(58);
        if (pos == -1) {
            Logger.error((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0029_OUTPUT_HANDLER_NOT_SPECIFIED", contentTag));
            return null;
        }
        String handlerId = contentTag.substring(0, pos);
        String contentRef = contentTag.substring(pos + 1);
        IContentOutputHandler output = PentahoSystem.get(IContentOutputHandler.class, handlerId, session);
        if (output != null) {
            output.setHandlerId(handlerId);
            output.setSession(session);
            output.setContentRef(contentRef);
        }
        return output;
    }

    public static <T> T get(Class<T> interfaceClass) {
        return PentahoSystem.get(interfaceClass, interfaceClass.getSimpleName(), PentahoSessionHolder.getSession());
    }

    public static <T> T get(Class<T> interfaceClass, IPentahoSession session) {
        IPentahoSession curSession = session == null ? PentahoSessionHolder.getSession() : session;
        return PentahoSystem.get(interfaceClass, interfaceClass.getSimpleName(), curSession);
    }

    public static <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) {
        try {
            if (!pentahoObjectFactory.objectDefined(key)) {
                Logger.warn((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.WARN_OBJECT_NOT_CONFIGURED", key));
                return null;
            }
            IPentahoSession curSession = session == null ? PentahoSessionHolder.getSession() : session;
            return (T)pentahoObjectFactory.get(interfaceClass, key, curSession);
        }
        catch (ObjectFactoryException e) {
            Logger.error((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0026_COULD_NOT_RETRIEVE_CONFIGURED_OBJECT", key), (Throwable)e);
            return null;
        }
    }

    public static String getSystemName() {
        return Messages.getString("PentahoSystem.USER_SYSTEM_TITLE");
    }

    public static IParameterProvider getGlobalParameters() {
        return globalParameters;
    }

    public static void sessionStartup(IPentahoSession session) {
        PentahoSystem.sessionStartup(session, null);
    }

    public static void clearGlobals() {
        globalAttributes.clear();
    }

    public static Object putInGlobalAttributesMap(Object key, Object value) {
        return globalAttributes.put(key, value);
    }

    public static Object removeFromGlobalAttributesMap(Object key) {
        return globalAttributes.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sessionStartup(IPentahoSession session, IParameterProvider sessionParameters) {
        List<ISessionStartupAction> sessionStartupActions = PentahoSystem.getSessionStartupActionsForType(session.getClass().getName());
        if (sessionStartupActions == null) {
            return;
        }
        if (!session.isAuthenticated()) {
            return;
        }
        Logger.debug(PentahoSystem.class, (String)"Process session startup actions");
        if (sessionStartupActions != null) {
            for (ISessionStartupAction sessionStartupAction : sessionStartupActions) {
                ActionInfo actionInfo = ActionInfo.parseActionString(sessionStartupAction.getActionPath());
                if (actionInfo != null) {
                    IOutputHandler outputHandler = null;
                    String instanceId = null;
                    ISolutionEngine solutionEngine = PentahoSystem.get(ISolutionEngine.class, session);
                    solutionEngine.setLoggingLevel(loggingLevel);
                    solutionEngine.init(session);
                    String baseUrl = "";
                    HashMap<String, IParameterProvider> parameterProviderMap = new HashMap<String, IParameterProvider>();
                    if (sessionParameters == null) {
                        sessionParameters = new PentahoSessionParameterProvider(session);
                    }
                    parameterProviderMap.put(SCOPE_SESSION, sessionParameters);
                    SimpleUrlFactory urlFactory = new SimpleUrlFactory(baseUrl);
                    ArrayList messages = new ArrayList();
                    IRuntimeContext context = null;
                    try {
                        context = solutionEngine.execute(actionInfo.getSolutionName(), actionInfo.getPath(), actionInfo.getActionName(), "Session startup actions", false, true, instanceId, false, parameterProviderMap, outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
                        if (null == context) {
                            return;
                        }
                        if (context.getStatus() != 6) continue;
                        for (String attributeName : context.getOutputNames()) {
                            IActionParameter output = context.getOutputParameter(attributeName);
                            Object data = output.getValue();
                            if (data == null) continue;
                            session.removeAttribute(attributeName);
                            session.setAttribute(attributeName, data);
                        }
                        continue;
                    }
                    finally {
                        if (context != null) {
                            context.dispose();
                        }
                        continue;
                    }
                }
                Logger.error((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0016_COULD_NOT_PARSE_ACTION", sessionStartupAction.getActionPath()));
            }
        }
    }

    public static void globalStartup() {
        List<ISessionStartupAction> globalStartupActions = PentahoSystem.getGlobalStartupActions();
        if (globalStartupActions == null || globalStartupActions.size() == 0) {
            return;
        }
        Logger.debug(PentahoSystem.class, (String)"Process global startup actions");
        IPentahoSession session = null;
        try {
            session = (IPentahoSession)pentahoObjectFactory.get(IPentahoSession.class, "systemStartupSession", null);
            PentahoSystem.globalStartup(session);
        }
        catch (ObjectFactoryException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void globalStartup(IPentahoSession session) {
        boolean doGlobals;
        List<ISessionStartupAction> globalStartupActions = PentahoSystem.getGlobalStartupActions();
        if (globalStartupActions == null) {
            return;
        }
        boolean bl = doGlobals = globalAttributes.size() == 0;
        if (!doGlobals) {
            return;
        }
        if (globalStartupActions != null) {
            for (ISessionStartupAction globalStartupAction : globalStartupActions) {
                ActionInfo actionInfo = ActionInfo.parseActionString(globalStartupAction.getActionPath());
                if (actionInfo != null) {
                    IOutputHandler outputHandler = null;
                    String instanceId = null;
                    ISolutionEngine solutionEngine = PentahoSystem.get(ISolutionEngine.class, session);
                    solutionEngine.setLoggingLevel(loggingLevel);
                    solutionEngine.init(session);
                    String baseUrl = "";
                    HashMap parameterProviderMap = new HashMap();
                    SimpleUrlFactory urlFactory = new SimpleUrlFactory(baseUrl);
                    ArrayList messages = new ArrayList();
                    IRuntimeContext context = null;
                    try {
                        context = solutionEngine.execute(actionInfo.getSolutionName(), actionInfo.getPath(), actionInfo.getActionName(), "Global startup actions", false, true, instanceId, false, parameterProviderMap, outputHandler, null, (IPentahoUrlFactory)urlFactory, messages);
                        if (null == context) {
                            return;
                        }
                        if (context.getStatus() != 6) continue;
                        for (String attributeName : context.getOutputNames()) {
                            IActionParameter output = context.getOutputParameter(attributeName);
                            Object data = output.getValue();
                            if (data == null) continue;
                            globalAttributes.remove(attributeName);
                            globalAttributes.put(attributeName, data);
                        }
                        continue;
                    }
                    finally {
                        if (context != null) {
                            context.dispose();
                        }
                        continue;
                    }
                }
                Logger.error((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0016_COULD_NOT_PARSE_ACTION", globalStartupAction.getActionPath()));
            }
        }
    }

    public static void shutdown() {
        if (LocaleHelper.getLocale() == null) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        Logger.debug(PentahoSystem.class, (String)"Shutdown Listeners");
        if (listeners != null) {
            for (IPentahoSystemListener listener : listeners) {
                if (listener == null) continue;
                Logger.debug(PentahoSystem.class, (String)("Shutdown Listener: " + listener.getClass().getName()));
                try {
                    listener.shutdown();
                }
                catch (Throwable e) {
                    Logger.error((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0015_SHUTDOWN_FAILURE", listener.getClass().getName()), (Throwable)e);
                }
            }
        }
        Logger.debug(PentahoSystem.class, (String)"Listeners Shut Down");
    }

    public static IApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Deprecated
    public static Object createObject(String className, ILogger logger) {
        Object object = null;
        try {
            Class<?> componentClass = Class.forName(className.trim());
            object = componentClass.newInstance();
        }
        catch (Throwable t) {
            String msg = Messages.getErrorString("PentahoSystem.ERROR_0013_COULD_NOT_CREATE_OBEJCT", className);
            if (null == logger) {
                Logger.fatal((String)PentahoSystem.class.getName(), (String)msg, (Throwable)t);
            }
            logger.fatal(msg, t);
        }
        return object;
    }

    public static void setUserDetailsRoleListService(IUserDetailsRoleListService value) {
        userDetailsRoleListService = value;
    }

    public static IUserDetailsRoleListService getUserDetailsRoleListService() {
        return userDetailsRoleListService;
    }

    @Deprecated
    public static Object createObject(String className) {
        return PentahoSystem.createObject(className, null);
    }

    public static String getSystemSetting(String path, String settingName, String defaultValue) {
        if (systemSettingsService == null) {
            return defaultValue;
        }
        return systemSettingsService.getSystemSetting(path, settingName, defaultValue);
    }

    public static String getSystemSetting(String settingName, String defaultValue) {
        if (systemSettingsService == null) {
            return defaultValue;
        }
        return systemSettingsService.getSystemSetting(settingName, defaultValue);
    }

    public static ISystemSettings getSystemSettings() {
        return systemSettingsService;
    }

    public static void refreshSettings() {
        systemSettingsService.resetSettingsCache();
    }

    public static String publish(IPentahoSession session, String className) {
        Logger.debug(PentahoSystem.class, (String)"Publisher execution");
        for (IPentahoPublisher publisher : administrationPlugins) {
            if (publisher == null || className != null && !className.equals(publisher.getClass().getName())) continue;
            try {
                Logger.debug(PentahoSystem.class, (String)("Publisher publish: " + publisher.getClass().getName()));
                return publisher.publish(session, loggingLevel);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return Messages.getErrorString("PentahoSystem.ERROR_0017_PUBLISHER_NOT_FOUND");
    }

    public static List getPublisherList() {
        return new ArrayList<IPentahoPublisher>(administrationPlugins);
    }

    public static Document getPublishersDocument() {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("publishers");
        if (administrationPlugins != null) {
            for (IPentahoPublisher publisher : administrationPlugins) {
                if (publisher == null) continue;
                try {
                    Element publisherNode = root.addElement("publisher");
                    publisherNode.addElement("name").setText(publisher.getName());
                    publisherNode.addElement("description").setText(publisher.getDescription());
                    publisherNode.addElement("class").setText(publisher.getClass().getName());
                }
                catch (Throwable e) {}
            }
        }
        return document;
    }

    public static void systemEntryPoint() {
        if (applicationContext != null) {
            applicationContext.invokeEntryPoints();
        }
    }

    public static void systemExitPoint() {
        if (applicationContext != null) {
            applicationContext.invokeExitPoints();
        }
    }

    private static void registerHostnameVerifier() {
        try {
            String LOCALHOST = "localhost";
            String tmphost = "localhost";
            try {
                String fullyQualifiedServerURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
                if (null == fullyQualifiedServerURL) {
                    return;
                }
                URL url = new URL(fullyQualifiedServerURL);
                tmphost = url.getHost();
            }
            catch (MalformedURLException e) {
                Logger.warn((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0030_VERIFIER_FAILED"), (Throwable)e);
            }
            final String host = tmphost;
            HostnameVerifier myHv = new HostnameVerifier(){

                public boolean verify(String hostName, SSLSession session) {
                    return hostName.equals(host) || hostName.equals("localhost");
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(myHv);
        }
        catch (Throwable t) {
            Logger.warn((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0030_VERIFIER_FAILED"), (Throwable)t);
        }
    }

    public static ICacheManager getCacheManager(IPentahoSession session) {
        try {
            ICacheManager cacheManager = (ICacheManager)pentahoObjectFactory.get(ICacheManager.class, session);
            return cacheManager;
        }
        catch (ObjectFactoryException e) {
            SimpleMapCacheManager cacheManager = SimpleMapCacheManager.getInstance();
            Logger.warn((String)PentahoSystem.class.getName(), (String)"Using default cache manager");
            return cacheManager;
        }
    }

    public static List getACLFileExtensionList() {
        return UnmodifiableACLFileExtensionList;
    }

    public static void addLogoutListener(ILogoutListener listener) {
        if (logoutListeners.contains(listener)) {
            return;
        }
        logoutListeners.add(listener);
    }

    public static ILogoutListener remove(ILogoutListener listener) {
        if (logoutListeners.remove(listener)) {
            return listener;
        }
        return null;
    }

    public static void invokeLogoutListeners(IPentahoSession session) {
        for (ILogoutListener listener : logoutListeners) {
            listener.onLogout(session);
        }
    }

    public static IPentahoObjectFactory getObjectFactory() {
        return pentahoObjectFactory;
    }

    public static void setObjectFactory(IPentahoObjectFactory pentahoObjectFactory) {
        PentahoSystem.pentahoObjectFactory = pentahoObjectFactory;
    }

    public static void setAdministrationPlugins(List<IPentahoPublisher> administrationPlugins) {
        PentahoSystem.administrationPlugins = administrationPlugins;
    }

    public static void setSystemListeners(List<IPentahoSystemListener> systemListeners) {
        listeners = systemListeners;
    }

    public static void setSessionStartupActions(List<ISessionStartupAction> actions) {
        sessionStartupActions = actions;
    }

    public static void setSystemSettingsService(ISystemSettings systemSettingsService) {
        PentahoSystem.systemSettingsService = systemSettingsService;
    }

    private static List<ISessionStartupAction> getSessionStartupActionsForType(String sessionClassName) {
        ArrayList<ISessionStartupAction> startupActions = new ArrayList<ISessionStartupAction>();
        if (sessionStartupActions != null) {
            for (ISessionStartupAction sessionStartupAction : sessionStartupActions) {
                if (!sessionStartupAction.getSessionType().equals(sessionClassName) || !sessionStartupAction.getActionOutputScope().equals(SCOPE_SESSION)) continue;
                startupActions.add(sessionStartupAction);
            }
        }
        return startupActions;
    }

    private static List<ISessionStartupAction> getGlobalStartupActions() {
        ArrayList<ISessionStartupAction> startupActions = new ArrayList<ISessionStartupAction>();
        if (sessionStartupActions != null) {
            for (ISessionStartupAction sessionStartupAction : sessionStartupActions) {
                if (!sessionStartupAction.getActionOutputScope().equals(SCOPE_GLOBAL)) continue;
                startupActions.add(sessionStartupAction);
            }
        }
        return startupActions;
    }

    private static void validateObjectFactory() throws PentahoSystemException {
        boolean isValid;
        boolean isRequiredValid = true;
        for (String interfaceName : RequiredObjects) {
            isValid = pentahoObjectFactory.objectDefined(interfaceName);
            isRequiredValid &= isValid;
            if (isValid) continue;
            Logger.fatal((String)PentahoSystem.class.getName(), (String)Messages.getErrorString("PentahoSystem.ERROR_0021_OBJECT_NOT_SPECIFIED", interfaceName));
        }
        for (String interfaceName : KnownOptionalObjects) {
            isValid = pentahoObjectFactory.objectDefined(interfaceName);
            if (isValid) continue;
            Logger.info((String)PentahoSystem.class.getName(), (String)Messages.getString("PentahoSystem.ERROR_0021_OBJECT_NOT_SPECIFIED", interfaceName));
        }
        if (!isRequiredValid) {
            throw new PentahoSystemException(Messages.getErrorString("PentahoSystem.ERROR_0420_MISSING_REQUIRED_OBJECT"));
        }
    }

    static {
        administrationPlugins = new ArrayList<IPentahoPublisher>();
        listeners = new ArrayList<IPentahoSystemListener>();
        sessionStartupActions = new ArrayList<ISessionStartupAction>();
        pentahoObjectFactory = null;
        initializationFailureDetailsMap = Collections.synchronizedMap(new HashMap());
        RequiredObjects = new ArrayList<String>();
        KnownOptionalObjects = new ArrayList<String>();
        IgnoredObjects = new ArrayList<String>();
        SYSTEM_LISTENERS_FAILED = (int)Math.pow(2.0, 0.0);
        SYSTEM_OBJECTS_FAILED = (int)Math.pow(2.0, 1.0);
        SYSTEM_PUBLISHERS_FAILED = (int)Math.pow(2.0, 2.0);
        SYSTEM_AUDIT_FAILED = (int)Math.pow(2.0, 3.0);
        SYSTEM_PENTAHOXML_FAILED = (int)Math.pow(2.0, 4.0);
        SYSTEM_SETTINGS_FAILED = (int)Math.pow(2.0, 5.0);
        SYSTEM_OTHER_FAILED = (int)Math.pow(2.0, 6.0);
        initializedStatus = -1;
        ACLFileExtensionList = new ArrayList();
        UnmodifiableACLFileExtensionList = UnmodifiableList.decorate((List)ACLFileExtensionList);
        logoutListeners = Collections.synchronizedList(new ArrayList());
        RequiredObjects.add(SOLUTION_ENGINE);
        KnownOptionalObjects.add(SOLUTION_REPOSITORY);
        KnownOptionalObjects.add(ACL_VOTER);
        KnownOptionalObjects.add(CONDITIONAL_EXECUTION);
        KnownOptionalObjects.add(RUNTIME_REPOSITORY);
        KnownOptionalObjects.add(SUBSCRIPTION_SCHEDULER);
        KnownOptionalObjects.add(SUBSCRIPTION_REPOSITORY);
        KnownOptionalObjects.add(CACHE_MANAGER);
        KnownOptionalObjects.add(CONTENT_REPOSITORY);
        KnownOptionalObjects.add("IUITemplater");
        KnownOptionalObjects.add("IUserFilesComponent");
        KnownOptionalObjects.add(BACKGROUND_EXECUTION);
        KnownOptionalObjects.add(SCHEDULER);
        KnownOptionalObjects.add(MESSAGE_FORMATTER);
        KnownOptionalObjects.add(NAVIGATION_COMPONENT);
        KnownOptionalObjects.add(USERSETTING_SERVICE);
        IgnoredObjects.add("IAuditEntry");
    }
}

