/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.BasePublisher;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class SettingsPublisher
extends BasePublisher {
    private static final long serialVersionUID = -4584778481507215709L;
    private static final Log logger = LogFactory.getLog(SettingsPublisher.class);

    public Log getLogger() {
        return logger;
    }

    public String getName() {
        return Messages.getString("SettingsPublisher.USER_SYSTEM_SETTINGS");
    }

    public String getDescription() {
        return Messages.getString("SettingsPublisher.USER_DESCRIPTION", PentahoSystem.getApplicationContext().getSolutionPath("system").replace('\\', '/'));
    }

    public String publish(IPentahoSession localSession) {
        try {
            PentahoSystem.refreshSettings();
        }
        catch (Throwable t) {
            this.error(Messages.getErrorString("SettingsPublisher.ERROR_0001_PUBLISH_FAILED"), t);
            return Messages.getString("SettingsPublisher.USER_ERROR_PUBLISH_FAILED") + t.getLocalizedMessage();
        }
        return Messages.getString("SettingsPublisher.USER_SYSTEM_SETTINGS_UPDATED");
    }
}

