/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;

public class UserSession
extends StandaloneSession {
    private static final long serialVersionUID = -5078190319798278211L;
    private static final Log logger = LogFactory.getLog(UserSession.class);

    public Log getLogger() {
        return logger;
    }

    public UserSession(String userName, Locale locale, boolean authenticated, IParameterProvider sessionParameters) {
        super(userName, userName, locale);
        AuditHelper.audit(this.getId(), this.getName(), this.getActionName(), this.getObjectName(), "", "session_start", "", "", 0.0f, null);
        if (authenticated) {
            this.setAuthenticated(userName);
            PentahoSystem.sessionStartup(this, sessionParameters);
        }
    }

    public void doStartupActions(IParameterProvider sessionParameters) {
        if (this.isAuthenticated()) {
            PentahoSystem.sessionStartup(this, sessionParameters);
        }
    }

    public UserSession(String userName, Locale locale, IParameterProvider sessionParameters) {
        super(userName, userName, locale);
        AuditHelper.audit(this.getId(), this.getName(), this.getActionName(), this.getObjectName(), "", "session_start", "", "", 0.0f, null);
        PentahoSystem.sessionStartup(this, sessionParameters);
    }

    public void destroy() {
        AuditHelper.audit(this.getId(), this.getName(), this.getActionName(), this.getObjectName(), "", "session_end", "", "", 0.0f, null);
        super.destroy();
    }
}

