/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.core.system.objfac;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.messages.Messages;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.util.logging.Logger;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpringPentahoObjectFactory
implements IPentahoObjectFactory {
    protected ApplicationContext beanFactory;
    protected static final Log logger = LogFactory.getLog(AbstractSpringPentahoObjectFactory.class);

    public <T> T get(Class<T> interfaceClass, IPentahoSession session) throws ObjectFactoryException {
        return this.get(interfaceClass, interfaceClass.getSimpleName(), session);
    }

    public <T> T get(Class<T> interfaceClass, String key, IPentahoSession session) throws ObjectFactoryException {
        return (T)this.retreiveObject(key, session);
    }

    protected Object instanceClass(String key) throws ObjectFactoryException {
        Object object = null;
        try {
            object = this.beanFactory.getType(key).newInstance();
        }
        catch (Exception e) {
            String msg = Messages.getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_CREATE_OBJECT", key);
            throw new ObjectFactoryException(msg, (Throwable)e);
        }
        return object;
    }

    protected Object retrieveViaSpring(String beanId) throws ObjectFactoryException {
        Object object = null;
        try {
            object = this.beanFactory.getBean(beanId);
        }
        catch (Throwable t) {
            String msg = Messages.getString("AbstractSpringPentahoObjectFactory.WARN_FAILED_TO_RETRIEVE_OBJECT", beanId);
            throw new ObjectFactoryException(msg, t);
        }
        return object;
    }

    protected Object retreiveObject(String key, IPentahoSession session) throws ObjectFactoryException {
        logger.debug((Object)("Attempting to get an instance of [" + key + "] while in session [" + session + "]"));
        Object object = null;
        if (session != null && session instanceof StandaloneSession) {
            try {
                object = this.beanFactory.getBean(key);
            }
            catch (Throwable t) {
                Logger.debug((Object)this, (String)"Retrieving object from Pentaho session map (not Spring).");
                object = session.getAttribute(key);
                if (object == null) {
                    object = this.instanceClass(key);
                    session.setAttribute(key, object);
                }
            }
        } else {
            object = this.retrieveViaSpring(key);
        }
        if (object instanceof IPentahoInitializer) {
            ((IPentahoInitializer)object).init(session);
        }
        logger.debug((Object)("Got an instance of [" + key + "]: " + object));
        return object;
    }

    public boolean objectDefined(String key) {
        return this.beanFactory.containsBean(key);
    }

    public Class getImplementingClass(String key) {
        return this.beanFactory.getType(key);
    }
}

