/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.scriptable;

import java.util.LinkedHashMap;
import javax.swing.table.TableModel;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.DataFactoryScriptingSupport;
import org.pentaho.reporting.engine.classic.core.states.LegacyDataRowWrapper;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ScriptableDataFactory
implements DataFactory,
Cloneable {
    private LinkedHashMap<String, String> queries = new LinkedHashMap();
    private String language;
    private transient BSFManager interpreter;
    private transient LegacyDataRowWrapper dataRowWrapper;
    private String script;
    private String shutdownScript;
    private transient Configuration configuration;
    private transient ResourceManager resourceManager;
    private transient ResourceKey contextKey;
    private transient ResourceBundleFactory resourceBundleFactory;

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
        this.configuration = configuration;
        this.resourceManager = resourceManager;
        this.contextKey = contextKey;
        this.resourceBundleFactory = resourceBundleFactory;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setQuery(String name, String value) {
        if (value == null) {
            this.queries.remove(name);
        } else {
            this.queries.put(name, value);
        }
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getShutdownScript() {
        return this.shutdownScript;
    }

    public void setShutdownScript(String shutdownScript) {
        this.shutdownScript = shutdownScript;
    }

    public String getQuery(String name) {
        return this.queries.get(name);
    }

    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    public void open() throws ReportDataFactoryException {
    }

    protected BSFManager createInterpreter() throws BSFException {
        BSFManager interpreter = new BSFManager();
        this.initializeInterpreter(interpreter);
        return interpreter;
    }

    protected void initializeInterpreter(BSFManager interpreter) throws BSFException {
        this.dataRowWrapper = new LegacyDataRowWrapper();
        interpreter.declareBean("dataRow", (Object)this.dataRowWrapper, DataRow.class);
        interpreter.declareBean("configuration", (Object)this.configuration, Configuration.class);
        interpreter.declareBean("contextKey", (Object)this.contextKey, ResourceKey.class);
        interpreter.declareBean("resourceManager", (Object)this.resourceManager, ResourceManager.class);
        interpreter.declareBean("resourceBundleFactory", (Object)this.resourceBundleFactory, ResourceBundleFactory.class);
        if (this.script != null) {
            interpreter.exec(this.getLanguage(), "startup-script", 1, 1, (Object)this.getScript());
        }
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        String queryScript = this.queries.get(query);
        if (queryScript == null) {
            throw new ReportDataFactoryException("No such query");
        }
        if (this.interpreter == null) {
            try {
                this.interpreter = this.createInterpreter();
            }
            catch (BSFException e) {
                throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", (Throwable)e);
            }
        }
        try {
            this.dataRowWrapper.setParent(parameters);
            Object o = this.interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)queryScript);
            Object translated = DataFactoryScriptingSupport.convert((Object)o);
            if (!(translated instanceof TableModel)) {
                throw new ReportDataFactoryException("Resulting value is not a tablemodel");
            }
            return (TableModel)o;
        }
        catch (ReportDataFactoryException rde) {
            throw rde;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Evaluation error", (Throwable)e);
        }
    }

    public Object clone() {
        try {
            ScriptableDataFactory dataFactory = (ScriptableDataFactory)super.clone();
            dataFactory.queries = (LinkedHashMap)this.queries.clone();
            dataFactory.interpreter = null;
            dataFactory.dataRowWrapper = null;
            return dataFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone datafactory", e);
        }
    }

    public DataFactory derive() {
        return (ScriptableDataFactory)this.clone();
    }

    public void close() {
        if (this.interpreter != null && this.shutdownScript != null) {
            try {
                this.interpreter.eval(this.getLanguage(), "shutdown-script", 1, 1, (Object)this.getShutdownScript());
            }
            catch (BSFException e) {
                DebugLog.log((Object)"Failed to evaluate shutdown-script", (Throwable)e);
            }
        }
        this.dataRowWrapper = null;
        this.interpreter = null;
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    public void cancelRunningQuery() {
        if (this.interpreter != null) {
            this.interpreter.terminate();
        }
    }
}

