/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.AbstractReportProcessTask;
import org.pentaho.reporting.engine.classic.core.MultiStreamReportProcessTask;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.FileSystemURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.SingleRepositoryURLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.UrlRepository;

public abstract class AbstractMultiStreamReportProcessTask
extends AbstractReportProcessTask
implements MultiStreamReportProcessTask {
    private ContentLocation bulkLocation;
    private NameGenerator bulkNameGenerator;
    private URLRewriter urlRewriter;

    protected AbstractMultiStreamReportProcessTask() {
    }

    public ContentLocation getBulkLocation() {
        return this.bulkLocation;
    }

    public void setBulkLocation(ContentLocation bulkLocation) {
        this.bulkLocation = bulkLocation;
    }

    public NameGenerator getBulkNameGenerator() {
        return this.bulkNameGenerator;
    }

    public void setBulkNameGenerator(NameGenerator bulkNameGenerator) {
        this.bulkNameGenerator = bulkNameGenerator;
    }

    public URLRewriter getUrlRewriter() {
        return this.urlRewriter;
    }

    public void setUrlRewriter(URLRewriter urlRewriter) {
        this.urlRewriter = urlRewriter;
    }

    protected URLRewriter computeUrlRewriter() {
        Repository bodyRepository;
        URLRewriter userRewriter = this.getUrlRewriter();
        if (userRewriter != null) {
            return userRewriter;
        }
        ContentLocation bulkLocation = this.getBulkLocation();
        if (bulkLocation == null) {
            return new SingleRepositoryURLRewriter();
        }
        Repository bulkRepository = bulkLocation.getRepository();
        if (bulkRepository == (bodyRepository = this.getBodyContentLocation().getRepository())) {
            return new SingleRepositoryURLRewriter();
        }
        if (bulkRepository instanceof UrlRepository && bodyRepository instanceof UrlRepository) {
            return new FileSystemURLRewriter();
        }
        return new SingleRepositoryURLRewriter();
    }
}

