/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactorySupport;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class CompoundDataFactory
implements DataFactory,
CompoundDataFactorySupport {
    private ArrayList<DataFactory> dataFactories = new ArrayList();

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) throws ReportDataFactoryException {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            dataFactory.initialize(configuration, resourceManager, contextKey, resourceBundleFactory);
        }
    }

    public void open() throws ReportDataFactoryException {
    }

    public final TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        if (parameters == null) {
            throw new NullPointerException();
        }
        if (query == null) {
            throw new NullPointerException();
        }
        TableModel staticResult = this.queryStatic(query, parameters);
        if (staticResult != null) {
            return staticResult;
        }
        TableModel freeFormResult = this.queryFreeForm(query, parameters);
        if (freeFormResult != null) {
            return freeFormResult;
        }
        return this.handleFallThrough(query);
    }

    public TableModel queryFreeForm(String query, DataRow parameters) throws ReportDataFactoryException {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (dataFactory instanceof CompoundDataFactorySupport) {
                CompoundDataFactorySupport support = (CompoundDataFactorySupport)dataFactory;
                if (!support.isFreeFormQueryExecutable(query, parameters)) continue;
                return support.queryFreeForm(query, parameters);
            }
            if (!this.isFreeFormQueryDataFactory(dataFactory) || !dataFactory.isQueryExecutable(query, parameters)) continue;
            return dataFactory.queryData(query, parameters);
        }
        return null;
    }

    public TableModel queryStatic(String query, DataRow parameters) throws ReportDataFactoryException {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (dataFactory instanceof CompoundDataFactorySupport) {
                CompoundDataFactorySupport support = (CompoundDataFactorySupport)dataFactory;
                if (!support.isStaticQueryExecutable(query, parameters)) continue;
                return support.queryStatic(query, parameters);
            }
            if (this.isFreeFormQueryDataFactory(dataFactory) || !dataFactory.isQueryExecutable(query, parameters)) continue;
            return dataFactory.queryData(query, parameters);
        }
        return null;
    }

    protected TableModel handleFallThrough(String query) throws ReportDataFactoryException {
        throw new ReportDataFactoryException("None of the data-factories was able to handle this query.");
    }

    private boolean isFreeFormQueryDataFactory(DataFactory dataFactory) {
        String metaDataKey;
        DataFactoryRegistry registry = DataFactoryRegistry.getInstance();
        if (!registry.isRegistered(metaDataKey = dataFactory.getClass().getName())) {
            return true;
        }
        DataFactoryMetaData metaData = registry.getMetaData(metaDataKey);
        return metaData.isFreeFormQuery();
    }

    public DataFactory derive() {
        CompoundDataFactory cdf = (CompoundDataFactory)this.clone();
        cdf.dataFactories = (ArrayList)this.dataFactories.clone();
        cdf.dataFactories.clear();
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            cdf.dataFactories.add(dataFactory.derive());
        }
        return cdf;
    }

    public void close() {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            dataFactory.close();
        }
    }

    public final boolean isQueryExecutable(String query, DataRow parameters) {
        return this.isStaticQueryExecutable(query, parameters) || this.isFreeFormQueryExecutable(query, parameters);
    }

    public boolean isFreeFormQueryExecutable(String query, DataRow parameters) {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            CompoundDataFactorySupport support;
            DataFactory dataFactory = this.dataFactories.get(i);
            if (!(dataFactory instanceof CompoundDataFactorySupport ? (support = (CompoundDataFactorySupport)dataFactory).isFreeFormQueryExecutable(query, parameters) : this.isFreeFormQueryDataFactory(dataFactory) && dataFactory.isQueryExecutable(query, parameters))) continue;
            return true;
        }
        return false;
    }

    public boolean isStaticQueryExecutable(String query, DataRow parameters) {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            CompoundDataFactorySupport support;
            DataFactory dataFactory = this.dataFactories.get(i);
            if (!(dataFactory instanceof CompoundDataFactorySupport ? (support = (CompoundDataFactorySupport)dataFactory).isStaticQueryExecutable(query, parameters) : !this.isFreeFormQueryDataFactory(dataFactory) && dataFactory.isQueryExecutable(query, parameters))) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void addRaw(DataFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        this.dataFactories.add(factory);
    }

    public void add(DataFactory factory) {
        if (factory == null) {
            throw new NullPointerException();
        }
        DataFactory derived = factory.derive();
        if (derived == null) {
            throw new IllegalStateException("Deriving failed silently. Fix your implementation of " + factory.getClass());
        }
        this.dataFactories.add(derived);
    }

    public void add(int index, DataFactory factory) throws ReportDataFactoryException {
        if (factory == null) {
            throw new NullPointerException();
        }
        DataFactory derived = factory.derive();
        if (derived == null) {
            throw new ReportDataFactoryException("Deriving failed silently. Fix your implementation of " + factory.getClass());
        }
        this.dataFactories.add(index, derived);
    }

    public void set(int index, DataFactory factory) throws ReportDataFactoryException {
        if (factory == null) {
            throw new NullPointerException();
        }
        DataFactory derived = factory.derive();
        if (derived == null) {
            throw new ReportDataFactoryException("Deriving failed silently. Fix your implementation of " + factory.getClass());
        }
        this.dataFactories.set(index, derived);
    }

    public void remove(int index) {
        this.dataFactories.remove(index);
    }

    public void remove(DataFactory dataFactory) {
        this.dataFactories.remove(dataFactory);
    }

    public int size() {
        return this.dataFactories.size();
    }

    public DataFactory get(int idx) {
        DataFactory df = this.dataFactories.get(idx);
        return df.derive();
    }

    public DataFactory getReference(int idx) {
        return this.dataFactories.get(idx);
    }

    public boolean isNormalized() {
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            if (!(dataFactory instanceof CompoundDataFactory)) continue;
            return false;
        }
        return true;
    }

    public static CompoundDataFactory normalize(DataFactory dataFactory) {
        return CompoundDataFactory.normalize(dataFactory, true);
    }

    public static CompoundDataFactory normalize(DataFactory dataFactory, boolean derive) {
        if (dataFactory == null) {
            return new CompoundDataFactory();
        }
        if (!(dataFactory instanceof CompoundDataFactory)) {
            CompoundDataFactory retval = new CompoundDataFactory();
            if (derive) {
                retval.add(dataFactory);
            } else {
                retval.addRaw(dataFactory);
            }
            return retval;
        }
        CompoundDataFactory cdf = (CompoundDataFactory)dataFactory;
        if (cdf.isNormalized()) {
            if (derive) {
                return (CompoundDataFactory)cdf.derive();
            }
            return cdf;
        }
        CompoundDataFactory retval = new CompoundDataFactory();
        int size = cdf.size();
        for (int i = 0; i < size; ++i) {
            DataFactory original = cdf.getReference(i);
            if (original instanceof CompoundDataFactory) {
                CompoundDataFactory container = CompoundDataFactory.normalize(original, derive);
                int containerSize = container.size();
                for (int x = 0; x < containerSize; ++x) {
                    if (derive) {
                        retval.add(container.getReference(x));
                        continue;
                    }
                    retval.addRaw(container.getReference(x));
                }
                continue;
            }
            if (derive) {
                retval.add(original);
                continue;
            }
            retval.addRaw(original);
        }
        return retval;
    }

    public String[] getQueryNames() {
        LinkedMap nameSet = new LinkedMap();
        for (int i = 0; i < this.dataFactories.size(); ++i) {
            DataFactory dataFactory = this.dataFactories.get(i);
            String[] queryNames = dataFactory.getQueryNames();
            for (int j = 0; j < queryNames.length; ++j) {
                String queryName = queryNames[j];
                nameSet.put((Object)queryName, (Object)queryName);
            }
        }
        return (String[])nameSet.keys((Object[])new String[nameSet.size()]);
    }

    public void cancelRunningQuery() {
    }

    public DataFactory getDataFactoryForQuery(String queryName, boolean freeform) {
        StaticDataRow dr = new StaticDataRow();
        for (int i = 0; i < this.size(); ++i) {
            CompoundDataFactorySupport cdf;
            DataFactory r;
            DataFactory df = this.dataFactories.get(i);
            if (df instanceof CompoundDataFactorySupport && (r = (cdf = (CompoundDataFactorySupport)df).getDataFactoryForQuery(queryName, freeform)) != null) {
                return r;
            }
            if (this.isFreeFormQueryDataFactory(df) != freeform || !df.isQueryExecutable(queryName, dr)) continue;
            return df;
        }
        return null;
    }

    public DataFactory getDataFactoryForQuery(String queryName) {
        DataFactory nonFreeForm = this.getDataFactoryForQuery(queryName, false);
        if (nonFreeForm != null) {
            return nonFreeForm;
        }
        DataFactory freeForm = this.getDataFactoryForQuery(queryName, true);
        if (freeForm != null) {
            return freeForm;
        }
        return null;
    }
}

