/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleFooter;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleHeader;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabColumnGroupType;

public class CrosstabColumnGroup
extends Group {
    private CrosstabTitleHeader titleHeader;
    private CrosstabTitleFooter titleFooter;

    public CrosstabColumnGroup() {
        this.setElementType(new CrosstabColumnGroupType());
        this.titleHeader = new CrosstabTitleHeader();
        this.titleFooter = new CrosstabTitleFooter();
        this.registerAsChild(this.titleHeader);
        this.registerAsChild(this.titleFooter);
    }

    public CrosstabTitleHeader getTitleHeader() {
        return this.titleHeader;
    }

    public void setTitleHeader(CrosstabTitleHeader titleHeader) {
        if (titleHeader == null) {
            throw new NullPointerException("titleHeader must not be null");
        }
        this.validateLooping(titleHeader);
        if (this.unregisterParent(titleHeader)) {
            return;
        }
        CrosstabTitleHeader element = this.titleHeader;
        this.titleHeader.setParent(null);
        this.titleHeader = titleHeader;
        this.titleHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.titleHeader);
    }

    public CrosstabTitleFooter getTitleFooter() {
        return this.titleFooter;
    }

    public void setTitleFooter(CrosstabTitleFooter titleFooter) {
        if (titleFooter == null) {
            throw new NullPointerException("titleFooter must not be null");
        }
        this.validateLooping(titleFooter);
        if (this.unregisterParent(titleFooter)) {
            return;
        }
        CrosstabTitleFooter element = this.titleFooter;
        this.titleFooter.setParent(null);
        this.titleFooter = titleFooter;
        this.titleFooter.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.titleFooter);
    }

    public String getField() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void setField(String field) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", field);
        this.notifyNodePropertiesChanged();
    }

    protected GroupBody createDefaultBody() {
        return new GroupDataBody();
    }

    public void setBody(GroupBody body) {
        if (!(body instanceof GroupDataBody) && !(body instanceof CrosstabColumnGroupBody)) {
            throw new IllegalArgumentException();
        }
        super.setBody(body);
    }

    public boolean isGroupChange(DataRow dataRow) {
        String field = this.getField();
        if (field == null) {
            return false;
        }
        return dataRow.isChanged(field);
    }

    public Object clone() throws CloneNotSupportedException {
        CrosstabColumnGroup element = (CrosstabColumnGroup)super.clone();
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.clone();
        element.titleFooter = (CrosstabTitleFooter)this.titleFooter.clone();
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.titleFooter);
        return element;
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        CrosstabColumnGroup element = (CrosstabColumnGroup)super.derive(preserveElementInstanceIds);
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.derive(preserveElementInstanceIds);
        element.titleFooter = (CrosstabTitleFooter)this.titleFooter.derive(preserveElementInstanceIds);
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.titleFooter);
        return element;
    }

    public int getElementCount() {
        return 5;
    }

    public ReportElement getElement(int index) {
        switch (index) {
            case 0: {
                return this.getTitleHeader();
            }
            case 1: {
                return this.getHeader();
            }
            case 2: {
                return this.getBody();
            }
            case 3: {
                return this.getTitleFooter();
            }
            case 4: {
                return this.getFooter();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setTitleHeader((CrosstabTitleHeader)element);
                break;
            }
            case 1: {
                this.setHeader((GroupHeader)element);
                break;
            }
            case 2: {
                this.setBody((GroupBody)element);
                break;
            }
            case 3: {
                this.setTitleFooter((CrosstabTitleFooter)element);
                break;
            }
            case 4: {
                this.setFooter((GroupFooter)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.titleHeader == element) {
            this.titleHeader.setParent(null);
            this.titleHeader = new CrosstabTitleHeader();
            this.titleHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.titleHeader);
        } else if (this.titleFooter == element) {
            this.titleFooter.setParent(null);
            this.titleFooter = new CrosstabTitleFooter();
            this.titleFooter.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.titleFooter);
        } else {
            super.removeElement(element);
        }
    }
}

