/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabSummaryFooter;
import org.pentaho.reporting.engine.classic.core.CrosstabSummaryHeader;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleFooter;
import org.pentaho.reporting.engine.classic.core.CrosstabTitleHeader;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.CrosstabRowGroupType;

public class CrosstabRowGroup
extends Group {
    private CrosstabTitleHeader titleHeader;
    private CrosstabTitleFooter titleFooter;
    private CrosstabSummaryHeader summaryHeader;
    private CrosstabSummaryFooter summaryFooter;

    public CrosstabRowGroup() {
        this.setElementType(new CrosstabRowGroupType());
        this.titleHeader = new CrosstabTitleHeader();
        this.titleFooter = new CrosstabTitleFooter();
        this.registerAsChild(this.titleHeader);
        this.registerAsChild(this.titleFooter);
        this.summaryHeader = new CrosstabSummaryHeader();
        this.summaryFooter = new CrosstabSummaryFooter();
        this.registerAsChild(this.summaryHeader);
        this.registerAsChild(this.summaryFooter);
    }

    public CrosstabTitleHeader getTitleHeader() {
        return this.titleHeader;
    }

    public void setTitleHeader(CrosstabTitleHeader titleHeader) {
        if (titleHeader == null) {
            throw new NullPointerException("titleHeader must not be null");
        }
        this.validateLooping(titleHeader);
        if (this.unregisterParent(titleHeader)) {
            return;
        }
        CrosstabTitleHeader element = this.titleHeader;
        this.titleHeader.setParent(null);
        this.titleHeader = titleHeader;
        this.titleHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.titleHeader);
    }

    public CrosstabTitleFooter getTitleFooter() {
        return this.titleFooter;
    }

    public void setTitleFooter(CrosstabTitleFooter titleFooter) {
        if (titleFooter == null) {
            throw new NullPointerException("titleFooter must not be null");
        }
        this.validateLooping(titleFooter);
        if (this.unregisterParent(titleFooter)) {
            return;
        }
        CrosstabTitleFooter element = this.titleFooter;
        this.titleFooter.setParent(null);
        this.titleFooter = titleFooter;
        this.titleFooter.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.titleFooter);
    }

    public CrosstabSummaryHeader getSummaryHeader() {
        return this.summaryHeader;
    }

    public void setSummaryHeader(CrosstabSummaryHeader summaryHeader) {
        if (summaryHeader == null) {
            throw new NullPointerException("summaryHeader must not be null");
        }
        this.validateLooping(summaryHeader);
        if (this.unregisterParent(summaryHeader)) {
            return;
        }
        CrosstabSummaryHeader element = this.summaryHeader;
        this.summaryHeader.setParent(null);
        this.summaryHeader = summaryHeader;
        this.summaryHeader.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.summaryHeader);
    }

    public CrosstabSummaryFooter getSummaryFooter() {
        return this.summaryFooter;
    }

    public void setSummaryFooter(CrosstabSummaryFooter summaryFooter) {
        if (summaryFooter == null) {
            throw new NullPointerException("summaryFooter must not be null");
        }
        this.validateLooping(summaryFooter);
        if (this.unregisterParent(summaryFooter)) {
            return;
        }
        CrosstabSummaryFooter element = this.summaryFooter;
        this.summaryFooter.setParent(null);
        this.summaryFooter = summaryFooter;
        this.summaryFooter.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.summaryFooter);
    }

    public String getField() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public void setField(String field) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", field);
        this.notifyNodePropertiesChanged();
    }

    protected GroupBody createDefaultBody() {
        return new CrosstabColumnGroupBody();
    }

    public void setBody(GroupBody body) {
        if (!(body instanceof CrosstabRowGroupBody) && !(body instanceof CrosstabColumnGroupBody)) {
            throw new IllegalArgumentException();
        }
        super.setBody(body);
    }

    public boolean isGroupChange(DataRow dataRow) {
        String field = this.getField();
        if (field == null) {
            return false;
        }
        return dataRow.isChanged(field);
    }

    public Object clone() throws CloneNotSupportedException {
        CrosstabRowGroup element = (CrosstabRowGroup)super.clone();
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.clone();
        element.titleFooter = (CrosstabTitleFooter)this.titleFooter.clone();
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.titleFooter);
        element.summaryHeader = (CrosstabSummaryHeader)this.summaryHeader.clone();
        element.summaryFooter = (CrosstabSummaryFooter)this.summaryFooter.clone();
        element.registerAsChild(element.summaryHeader);
        element.registerAsChild(element.summaryFooter);
        return element;
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        CrosstabRowGroup element = (CrosstabRowGroup)super.derive(preserveElementInstanceIds);
        element.titleHeader = (CrosstabTitleHeader)this.titleHeader.derive(preserveElementInstanceIds);
        element.titleFooter = (CrosstabTitleFooter)this.titleFooter.derive(preserveElementInstanceIds);
        element.registerAsChild(element.titleHeader);
        element.registerAsChild(element.titleFooter);
        element.summaryHeader = (CrosstabSummaryHeader)this.summaryHeader.derive(preserveElementInstanceIds);
        element.summaryFooter = (CrosstabSummaryFooter)this.summaryFooter.derive(preserveElementInstanceIds);
        element.registerAsChild(element.summaryHeader);
        element.registerAsChild(element.summaryFooter);
        return element;
    }

    public int getElementCount() {
        return 7;
    }

    public ReportElement getElement(int index) {
        switch (index) {
            case 0: {
                return this.getTitleHeader();
            }
            case 1: {
                return this.getHeader();
            }
            case 2: {
                return this.getSummaryHeader();
            }
            case 3: {
                return this.getBody();
            }
            case 4: {
                return this.getTitleFooter();
            }
            case 5: {
                return this.getFooter();
            }
            case 6: {
                return this.getSummaryFooter();
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setTitleHeader((CrosstabTitleHeader)element);
                break;
            }
            case 1: {
                this.setHeader((GroupHeader)element);
                break;
            }
            case 2: {
                this.setSummaryHeader((CrosstabSummaryHeader)element);
                break;
            }
            case 3: {
                this.setBody((GroupBody)element);
                break;
            }
            case 4: {
                this.setTitleFooter((CrosstabTitleFooter)element);
                break;
            }
            case 5: {
                this.setFooter((GroupFooter)element);
                break;
            }
            case 6: {
                this.setSummaryFooter((CrosstabSummaryFooter)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.titleHeader == element) {
            this.titleHeader.setParent(null);
            this.titleHeader = new CrosstabTitleHeader();
            this.titleHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.titleHeader);
        } else if (this.titleFooter == element) {
            this.titleFooter.setParent(null);
            this.titleFooter = new CrosstabTitleFooter();
            this.titleFooter.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.titleFooter);
        } else if (this.summaryHeader == element) {
            this.summaryHeader.setParent(null);
            this.summaryHeader = new CrosstabSummaryHeader();
            this.summaryHeader.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.summaryHeader);
        } else if (this.summaryFooter == element) {
            this.summaryFooter.setParent(null);
            this.summaryFooter = new CrosstabSummaryFooter();
            this.summaryFooter.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.summaryFooter);
        } else {
            super.removeElement(element);
        }
    }
}

