/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.util.PageFormatFactory;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class CustomPageDefinition
implements PageDefinition {
    private transient ArrayList pageBoundsList = new ArrayList();
    private transient ArrayList pageFormatList = new ArrayList();
    private float width;
    private float height;

    public void addPageFormat(PageFormat format, float x, float y) {
        if (format == null) {
            throw new NullPointerException("The given pageformat must not be null.");
        }
        this.width = Math.max(this.width, (float)(format.getImageableWidth() + (double)x));
        this.height = Math.max(this.height, (float)(format.getImageableHeight() + (double)y));
        Rectangle2D.Double bounds = new Rectangle2D.Double(x, y, format.getImageableWidth(), format.getImageableHeight());
        this.pageBoundsList.add(bounds);
        this.pageFormatList.add(format.clone());
    }

    public int getPageCount() {
        return this.pageBoundsList.size();
    }

    public PageFormat getPageFormat(int pos) {
        PageFormat fmt = (PageFormat)this.pageFormatList.get(pos);
        return (PageFormat)fmt.clone();
    }

    public Rectangle2D getPagePosition(int index) {
        Rectangle2D rec = (Rectangle2D)this.pageBoundsList.get(index);
        return rec.getBounds2D();
    }

    public Rectangle2D[] getPagePositions() {
        Rectangle2D[] rects = new Rectangle2D[this.pageBoundsList.size()];
        for (int i = 0; i < this.pageBoundsList.size(); ++i) {
            Rectangle2D rec = (Rectangle2D)this.pageBoundsList.get(i);
            rects[i] = rec.getBounds2D();
        }
        return rects;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Object clone() throws CloneNotSupportedException {
        CustomPageDefinition def = (CustomPageDefinition)super.clone();
        def.pageBoundsList = (ArrayList)this.pageBoundsList.clone();
        def.pageFormatList = (ArrayList)this.pageFormatList.clone();
        return def;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper instance = SerializerHelper.getInstance();
        Iterator pageBoundsIterator = this.pageBoundsList.iterator();
        while (pageBoundsIterator.hasNext()) {
            instance.writeObject(pageBoundsIterator.next(), out);
        }
        instance.writeObject(null, out);
        Iterator pageFormatIterator = this.pageFormatList.iterator();
        while (pageFormatIterator.hasNext()) {
            instance.writeObject(pageFormatIterator.next(), out);
        }
        instance.writeObject(null, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializerHelper instance = SerializerHelper.getInstance();
        this.pageBoundsList = new ArrayList();
        this.pageFormatList = new ArrayList();
        Object o = instance.readObject(in);
        while (o != null) {
            Rectangle2D rect = (Rectangle2D)o;
            this.pageBoundsList.add(rect);
            o = instance.readObject(in);
        }
        o = instance.readObject(in);
        while (o != null) {
            PageFormat format = (PageFormat)o;
            this.pageFormatList.add(format);
            o = instance.readObject(in);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomPageDefinition)) {
            return false;
        }
        CustomPageDefinition customPageDefinition = (CustomPageDefinition)obj;
        if (this.height != customPageDefinition.height) {
            return false;
        }
        if (this.width != customPageDefinition.width) {
            return false;
        }
        if (!this.pageBoundsList.equals(customPageDefinition.pageBoundsList)) {
            return false;
        }
        if (this.pageFormatList.size() != customPageDefinition.pageFormatList.size()) {
            return false;
        }
        for (int i = 0; i < this.pageFormatList.size(); ++i) {
            PageFormat cpf;
            PageFormat pf = (PageFormat)this.pageFormatList.get(i);
            if (PageFormatFactory.isEqual(pf, cpf = (PageFormat)customPageDefinition.pageFormatList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.pageBoundsList.hashCode();
        result = (float)(29 * (result = 29 * result + this.pageFormatList.hashCode())) + this.width == 0.0f ? 0 : Float.floatToIntBits(this.width);
        result = (float)(29 * result) + this.height == 0.0f ? 0 : Float.floatToIntBits(this.height);
        return result;
    }
}

