/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.Image;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultImageReference
implements Serializable,
URLImageContainer,
LocalImageContainer {
    private static final long serialVersionUID = 3223926147102983309L;
    private Image image;
    private URL url;
    private int width;
    private int height;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private ResourceKey resourceKey;

    public DefaultImageReference(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL must not be null.");
        }
        try {
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            Resource resource = resourceManager.createDirectly((Object)url, Image.class);
            this.url = url;
            this.resourceKey = resource.getSource();
            this.image = (Image)resource.getResource();
        }
        catch (ResourceException e) {
            throw new IOException("The image could not be loaded.");
        }
        WaitingImageObserver wob = new WaitingImageObserver(this.image);
        wob.waitImageLoaded();
        if (wob.isError()) {
            throw new IOException("Failed to load the image. ImageObserver signaled an error.");
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
    }

    public DefaultImageReference(Image img) throws IOException {
        if (img == null) {
            throw new NullPointerException();
        }
        this.image = img;
        WaitingImageObserver obs = new WaitingImageObserver(this.image);
        obs.waitImageLoaded();
        if (obs.isError()) {
            throw new IOException("Failed to load the image. ImageObserver signaled an error.");
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
    }

    public DefaultImageReference(Resource imageResource) throws ResourceException {
        if (imageResource == null) {
            throw new NullPointerException();
        }
        Object o = imageResource.getResource();
        if (!(o instanceof Image)) {
            throw new ResourceException("ImageResource does not contain a java.awt.Image object.");
        }
        ResourceKey resKey = imageResource.getSource();
        Object identifier = resKey.getIdentifier();
        if (identifier instanceof URL) {
            this.url = (URL)identifier;
        }
        this.resourceKey = resKey;
        this.image = (Image)o;
        WaitingImageObserver obs = new WaitingImageObserver(this.image);
        obs.waitImageLoaded();
        if (obs.isError()) {
            throw new ResourceException("Failed to load the image. ImageObserver signaled an error.");
        }
        this.width = this.image.getWidth(null);
        this.height = this.image.getHeight(null);
    }

    public DefaultImageReference(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public DefaultImageReference(DefaultImageReference parent) {
        if (parent == null) {
            throw new NullPointerException("The given parent must not be null.");
        }
        this.width = parent.width;
        this.height = parent.height;
        this.image = parent.image;
        this.url = parent.url;
        this.resourceKey = parent.resourceKey;
    }

    public Image getImage() {
        return this.image;
    }

    public URL getSourceURL() {
        return this.url;
    }

    public String getSourceURLString() {
        if (this.url == null) {
            return null;
        }
        return this.url.toExternalForm();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append("ImageReference={ URL=");
        buf.append(this.getSourceURL());
        buf.append(", key=");
        buf.append(this.getResourceKey());
        buf.append(", image=");
        buf.append(this.getImage());
        buf.append(", width=");
        buf.append(this.getImageWidth());
        buf.append(", height=");
        buf.append(this.getImageHeight());
        buf.append(", scaleX=");
        buf.append(this.getScaleX());
        buf.append(", scaleY=");
        buf.append(this.getScaleY());
        buf.append('}');
        return buf.toString();
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultImageReference)) {
            return false;
        }
        DefaultImageReference ref = (DefaultImageReference)obj;
        if (!ObjectUtilities.equal((Object)String.valueOf(this.url), (Object)String.valueOf(ref.url))) {
            return false;
        }
        if (this.width != ref.width) {
            return false;
        }
        if (this.height != ref.height) {
            return false;
        }
        if (this.scaleX != ref.scaleX) {
            return false;
        }
        return this.scaleY == ref.scaleY;
    }

    public int hashCode() {
        int result = this.width;
        result = 29 * result + this.height;
        result = 29 * result + Float.floatToIntBits(this.scaleX);
        result = 29 * result + Float.floatToIntBits(this.scaleY);
        result = 29 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 29 * result + (this.url != null ? this.url.toString().hashCode() : 0);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getImageWidth() {
        return this.width;
    }

    public int getImageHeight() {
        return this.height;
    }

    public boolean isLoadable() {
        return this.getResourceKey() != null;
    }

    public Object getIdentity() {
        if (this.url == null) {
            return null;
        }
        return String.valueOf(this.url);
    }

    public String getName() {
        if (this.url != null) {
            return this.url.toExternalForm();
        }
        return null;
    }

    public boolean isIdentifiable() {
        return this.url != null;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScale(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }
}

