/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ClassicEngineInfo;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.LocaleValueConverter;
import org.pentaho.reporting.engine.classic.core.util.beans.TimeZoneValueConverter;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.util.URLEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReportEnvironment
implements ReportEnvironment {
    public static final String ENVIRONMENT_KEY = "org.pentaho.reporting.engine.classic.core.environment.";
    private Configuration configuration;
    private Locale locale;
    private Locale localeFromConfiguration;
    private TimeZone timeZone;
    private TimeZone timeZoneFromConfiguration;

    public DefaultReportEnvironment(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.update(configuration);
    }

    @Override
    public String getEnvironmentProperty(String key) {
        if ("engine.version".equals(key)) {
            return ClassicEngineInfo.getInstance().getVersion();
        }
        if ("engine.version.major".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseMajor();
        }
        if ("engine.version.minor".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseMinor();
        }
        if ("engine.version.patch".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseMilestone();
        }
        if ("engine.version.candidate-token".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseCandidateToken();
        }
        if ("engine.version.buildnumber".equals(key)) {
            return ClassicEngineInfo.getInstance().getReleaseBuildNumber();
        }
        if ("engine.product-id".equals(key)) {
            return ClassicEngineInfo.getInstance().getProductId();
        }
        if ("engine.name".equals(key)) {
            return ClassicEngineInfo.getInstance().getName();
        }
        return this.configuration.getConfigProperty(ENVIRONMENT_KEY + key);
    }

    @Override
    public String getURLEncoding() {
        return this.configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.URLEncoding");
    }

    public void update(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
        String localeFromConfig = this.getEnvironmentProperty("designtime.Locale");
        if (localeFromConfig == null) {
            this.localeFromConfiguration = Locale.getDefault();
        } else {
            try {
                this.localeFromConfiguration = (Locale)new LocaleValueConverter().toPropertyValue(localeFromConfig);
            }
            catch (BeanException e) {
                this.localeFromConfiguration = Locale.getDefault();
            }
        }
        String timeZoneFromConfig = this.getEnvironmentProperty("designtime.TimeZone");
        if (timeZoneFromConfig == null) {
            this.timeZoneFromConfiguration = TimeZone.getDefault();
        } else {
            try {
                this.timeZoneFromConfiguration = (TimeZone)new TimeZoneValueConverter().toPropertyValue(timeZoneFromConfig);
            }
            catch (BeanException e) {
                this.timeZoneFromConfiguration = TimeZone.getDefault();
            }
        }
    }

    @Override
    public String encodeURL(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode((String)url, (String)this.getURLEncoding());
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return this.localeFromConfiguration;
    }

    @Override
    public TimeZone getTimeZone() {
        if (this.timeZone != null) {
            return this.timeZone;
        }
        return this.timeZoneFromConfiguration;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultReportEnvironment environment = (DefaultReportEnvironment)super.clone();
        environment.configuration = (Configuration)this.configuration.clone();
        return environment;
    }

    @Override
    public Map<String, String[]> getUrlExtraParameter() {
        return Collections.emptyMap();
    }
}

