/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;

public class DefaultResourceBundleFactory
implements ResourceBundleFactory {
    private Locale locale;
    private TimeZone timeZone;

    public DefaultResourceBundleFactory() {
        this(Locale.getDefault());
    }

    public DefaultResourceBundleFactory(Locale locale) {
        this(locale, TimeZone.getDefault());
    }

    public DefaultResourceBundleFactory(Locale locale, TimeZone timeZone) {
        if (locale == null) {
            throw new NullPointerException("Locale must not be null");
        }
        if (timeZone == null) {
            throw new NullPointerException("TimeZone must not be null");
        }
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Locale must not be null");
        }
        this.locale = locale;
    }

    public ResourceBundle getResourceBundle(String key) {
        return ResourceBundle.getBundle(key, this.locale);
    }
}

