/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeExpressionChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleChange;
import org.pentaho.reporting.engine.classic.core.designtime.StyleExpressionChange;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.filter.DataTarget;
import org.pentaho.reporting.engine.classic.core.filter.EmptyDataSource;
import org.pentaho.reporting.engine.classic.core.filter.types.LegacyType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleSheetCarrier;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.NullOutputStream;
import org.pentaho.reporting.libraries.base.util.Empty;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class Element
implements DataTarget,
ReportElement {
    private static final String[] EMPTY_NAMES = new String[0];
    private static final Log logger = LogFactory.getLog(Element.class);
    public static final String ANONYMOUS_ELEMENT_PREFIX = "anonymousElement@";
    private static final DataSource NULL_DATASOURCE = new EmptyDataSource();
    private DataSource datasource;
    private InternalElementStyleSheet style;
    private Section parent;
    private InstanceID treeLock;
    private HashMap styleExpressions;
    private transient ReportAttributeMap attributes;
    private ReportAttributeMap attributeExpressions;
    private transient ReportAttributeMap cachedAttributes;
    private transient long changeTracker;

    public Element() {
        this.treeLock = new InstanceID();
        this.datasource = NULL_DATASOURCE;
        this.style = new InternalElementStyleSheet(this);
        this.attributes = new ReportAttributeMap();
        this.attributes.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type", LegacyType.INSTANCE);
    }

    protected Element(InstanceID id) {
        this.treeLock = id;
        this.datasource = NULL_DATASOURCE;
        this.style = new InternalElementStyleSheet(this);
        this.attributes = new ReportAttributeMap();
        this.attributes.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type", LegacyType.INSTANCE);
    }

    public void setAttributeExpression(String namespace, String name, Expression value) {
        if (this.attributeExpressions == null) {
            this.attributeExpressions = new ReportAttributeMap();
        }
        Object oldExpression = this.attributeExpressions.setAttribute(namespace, name, value);
        this.notifyNodePropertiesChanged(new AttributeExpressionChange(namespace, name, (Expression)oldExpression, value));
    }

    public Expression getAttributeExpression(String namespace, String name) {
        if (this.attributeExpressions == null) {
            return null;
        }
        return (Expression)this.attributeExpressions.getAttribute(namespace, name);
    }

    public String[] getAttributeExpressionNamespaces() {
        if (this.attributeExpressions == null) {
            return EMPTY_NAMES;
        }
        return this.attributeExpressions.getNameSpaces();
    }

    public String[] getAttributeExpressionNames(String name) {
        if (this.attributeExpressions == null) {
            return EMPTY_NAMES;
        }
        return this.attributeExpressions.getNames(name);
    }

    public void setAttribute(String namespace, String name, Object value) {
        this.setAttribute(namespace, name, value, true);
    }

    public void setAttribute(String namespace, String name, Object value, boolean notifyChange) {
        Object oldValue = this.attributes.setAttribute(namespace, name, value);
        if (this.cachedAttributes != null && this.cachedAttributes.getChangeTracker() != this.attributes.getChangeTracker()) {
            this.cachedAttributes = null;
        }
        if (notifyChange) {
            this.notifyNodePropertiesChanged(new AttributeChange(namespace, name, oldValue, value));
        }
    }

    public Object getAttribute(String namespace, String name) {
        return this.attributes.getAttribute(namespace, name);
    }

    public String[] getAttributeNamespaces() {
        return this.attributes.getNameSpaces();
    }

    public String[] getAttributeNames(String name) {
        return this.attributes.getNames(name);
    }

    public ReportAttributeMap getAttributes() {
        if (this.cachedAttributes != null && this.cachedAttributes.getChangeTracker() == this.attributes.getChangeTracker()) {
            return this.cachedAttributes;
        }
        this.cachedAttributes = this.attributes.createUnmodifiableMap();
        return this.cachedAttributes;
    }

    public void setElementType(ElementType elementType) {
        if (elementType == null) {
            throw new NullPointerException("Element.setElementType(..): ElementType cannot be null");
        }
        this.attributes.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type", elementType);
    }

    public ElementType getElementType() {
        Object attribute = this.attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
        if (!(attribute instanceof ElementType)) {
            return LegacyType.INSTANCE;
        }
        return (ElementType)attribute;
    }

    public String getElementTypeName() {
        return this.getElementType().getMetaData().getName();
    }

    public final ElementMetaData getMetaData() {
        return this.getElementType().getMetaData();
    }

    public final Band getParent() {
        if (this.parent instanceof Band) {
            return (Band)this.parent;
        }
        return null;
    }

    public final Section getParentSection() {
        return this.parent;
    }

    protected final void setParent(Section parent) {
        this.parent = parent;
        this.style.parentChanged();
    }

    public void setName(String name) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "name", name);
    }

    public String getName() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "name");
        if (o != null) {
            return String.valueOf(o);
        }
        return "";
    }

    public final DataSource getDataSource() {
        return this.datasource;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException("Element.setDataSource(...) : null data source.");
        }
        this.datasource = ds;
        this.notifyNodePropertiesChanged();
    }

    public Object getValue(ExpressionRuntime runtime) {
        return this.getElementType().getValue(runtime, this);
    }

    public boolean isVisible() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.VISIBLE, false);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, Boolean.TRUE);
        } else {
            this.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, Boolean.FALSE);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() throws CloneNotSupportedException {
        Element e = (Element)super.clone();
        e.style = (InternalElementStyleSheet)this.style.getCopy();
        e.datasource = (DataSource)this.datasource.clone();
        e.parent = null;
        e.style.updateElementReference(e);
        e.style.parentChanged();
        e.attributes = (ReportAttributeMap)((Object)this.attributes.clone());
        if (this.attributeExpressions != null) {
            void var3_4;
            e.attributeExpressions = (ReportAttributeMap)((Object)this.attributeExpressions.clone());
            String[] namespaces = e.attributeExpressions.getNameSpaces();
            boolean bl = false;
            while (var3_4 < namespaces.length) {
                String namespace = namespaces[var3_4];
                Map attrsNs = this.attributeExpressions.getAttributes(namespace);
                for (Map.Entry entry : attrsNs.entrySet()) {
                    Expression exp = (Expression)entry.getValue();
                    e.attributeExpressions.setAttribute(namespace, (String)entry.getKey(), exp.clone());
                }
                ++var3_4;
            }
        }
        if (this.styleExpressions != null) {
            e.styleExpressions = (HashMap)this.styleExpressions.clone();
            for (Map.Entry entry : e.styleExpressions.entrySet()) {
                Expression exp = (Expression)entry.getValue();
                entry.setValue(exp.clone());
            }
        }
        return e;
    }

    public final Element derive() throws CloneNotSupportedException {
        return this.derive(false);
    }

    /*
     * WARNING - void declaration
     */
    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        Element e = (Element)super.clone();
        if (!preserveElementInstanceIds) {
            e.treeLock = new InstanceID();
        }
        e.style = (InternalElementStyleSheet)this.style.derive();
        e.datasource = (DataSource)this.datasource.clone();
        e.parent = null;
        e.style.updateElementReference(e);
        e.style.parentChanged();
        e.attributes = (ReportAttributeMap)((Object)this.attributes.clone());
        ElementMetaData metaData = e.getMetaData();
        String[] namespaces = e.attributes.getNameSpaces();
        for (int i = 0; i < namespaces.length; ++i) {
            String string = namespaces[i];
            Map attrsNs = this.attributes.getAttributes(string);
            for (Map.Entry entry : attrsNs.entrySet()) {
                Object value = entry.getValue();
                String name = (String)entry.getKey();
                AttributeMetaData data = metaData.getAttributeDescription(string, name);
                if (data == null && logger.isDebugEnabled()) {
                    logger.debug((Object)(this.getElementTypeName() + ": Attribute " + string + "|" + name + " is not listed in the metadata."));
                }
                if (value instanceof Cloneable) {
                    e.attributes.setAttribute(string, name, ObjectUtilities.clone(value));
                    continue;
                }
                if (data == null || !data.isComputed() || data.isDesignTimeValue()) {
                    e.attributes.setAttribute(string, name, value);
                    continue;
                }
                e.attributes.setAttribute(string, name, null);
            }
        }
        if (e.cachedAttributes != null && e.attributes.getChangeTracker() != e.cachedAttributes.getChangeTracker()) {
            e.cachedAttributes = null;
        }
        if (this.attributeExpressions != null) {
            void var6_10;
            e.attributeExpressions = (ReportAttributeMap)((Object)this.attributeExpressions.clone());
            String[] attrExprNamespaces = e.attributeExpressions.getNameSpaces();
            boolean bl = false;
            while (var6_10 < attrExprNamespaces.length) {
                String namespace = attrExprNamespaces[var6_10];
                Map attrsNs = this.attributeExpressions.getAttributes(namespace);
                for (Map.Entry entry : attrsNs.entrySet()) {
                    Expression exp = (Expression)entry.getValue();
                    e.attributeExpressions.setAttribute(namespace, (String)entry.getKey(), exp.getInstance());
                }
                ++var6_10;
            }
        }
        if (this.styleExpressions != null) {
            e.styleExpressions = (HashMap)this.styleExpressions.clone();
            for (Map.Entry entry : e.styleExpressions.entrySet()) {
                Expression exp = (Expression)entry.getValue();
                entry.setValue(exp.getInstance());
            }
        }
        return e;
    }

    public ElementStyleSheet getStyle() {
        return this.style;
    }

    public final Object getTreeLock() {
        Section parent = this.getParentSection();
        if (parent != null) {
            return parent.getTreeLock();
        }
        return this.treeLock;
    }

    public String getId() {
        return (String)this.getAttribute("http://www.w3.org/XML/1998/namespace", "id");
    }

    public void setId(String id) {
        this.setAttribute("http://www.w3.org/XML/1998/namespace", "id", id);
    }

    public final InstanceID getObjectID() {
        return this.treeLock;
    }

    public boolean isDynamicContent() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT);
    }

    public void setDynamicContent(boolean dynamicContent) {
        this.getStyle().setBooleanStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, dynamicContent);
    }

    public ReportDefinition getReportDefinition() {
        if (this.parent != null) {
            return this.parent.getReportDefinition();
        }
        return null;
    }

    public void setHRefTarget(String target) {
        this.getStyle().setStyleProperty(ElementStyleKeys.HREF_TARGET, target);
    }

    public String getHRefTarget() {
        return (String)this.getStyle().getStyleProperty(ElementStyleKeys.HREF_TARGET);
    }

    protected ElementDefaultStyleSheet createGlobalDefaultStyle() {
        return ElementDefaultStyleSheet.getDefaultStyle();
    }

    public void setStyleExpression(StyleKey property, Expression function) {
        if (this.styleExpressions == null) {
            if (function == null) {
                return;
            }
            this.styleExpressions = new HashMap();
        }
        Object oldValue = function == null ? this.styleExpressions.remove(property) : this.styleExpressions.put(property, function);
        this.notifyNodePropertiesChanged(new StyleExpressionChange(property, (Expression)oldValue, function));
    }

    public Expression getStyleExpression(StyleKey property) {
        if (this.styleExpressions == null) {
            return null;
        }
        return (Expression)this.styleExpressions.get(property);
    }

    public Map getStyleExpressions() {
        if (this.styleExpressions != null) {
            return Collections.unmodifiableMap(this.styleExpressions);
        }
        return Empty.MAP;
    }

    public ResourceKey getDefinitionSource() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source");
        if (o instanceof ResourceKey) {
            return (ResourceKey)o;
        }
        if (this.parent != null) {
            return this.parent.getDefinitionSource();
        }
        return null;
    }

    public ResourceKey getContentBase() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
        if (o instanceof ResourceKey) {
            return (ResourceKey)o;
        }
        if (this.parent != null) {
            return this.parent.getContentBase();
        }
        return null;
    }

    public long getChangeTracker() {
        return this.changeTracker;
    }

    public void notifyNodePropertiesChanged() {
        this.updateChangedFlagInternal(this, 0, null);
    }

    public void notifyNodePropertiesChanged(Object parameter) {
        this.updateChangedFlagInternal(this, 0, parameter);
    }

    public void notifyNodeChildAdded(Object o) {
        this.updateChangedFlagInternal(this, 1, o);
    }

    public void notifyNodeChildRemoved(Object o) {
        this.updateChangedFlagInternal(this, 2, o);
    }

    public void notifyNodeStructureChanged() {
        this.updateChangedFlagInternal(this, 3, null);
    }

    protected void updateChangedFlagInternal(ReportElement element, int type, Object parameter) {
        ++this.changeTracker;
        if (this.parent != null) {
            this.parent.updateChangedFlagInternal(element, type, parameter);
        }
    }

    protected final void updateInternalChangeFlag() {
        ++this.changeTracker;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        ReportAttributeMap attributes = this.attributes;
        stream.writeLong(attributes.getChangeTracker());
        String[] nameSpaces = attributes.getNameSpaces();
        stream.writeObject(nameSpaces);
        for (int i = 0; i < nameSpaces.length; ++i) {
            String nameSpace = nameSpaces[i];
            String[] names = attributes.getNames(nameSpace);
            stream.writeObject(names);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object attribute = attributes.getAttribute(nameSpace, name);
                AttributeMetaData data = this.getMetaData().getAttributeDescription(nameSpace, name);
                if (data != null && !data.isTransient()) {
                    if (attribute instanceof ResourceKey) {
                        ResourceKey key = (ResourceKey)attribute;
                        ResourceKey parent = key.getParent();
                        if ("http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(nameSpace) && ("content-base".equals(name) || "source".equals(name))) {
                            if (parent != null) {
                                if (this.isKeySerializable(parent)) {
                                    stream.writeByte(0);
                                    SerializerHelper.getInstance().writeObject((Object)parent, stream);
                                    continue;
                                }
                                stream.writeByte(1);
                                continue;
                            }
                            if (this.isKeySerializable(key)) {
                                stream.writeByte(0);
                                SerializerHelper.getInstance().writeObject((Object)key, stream);
                                continue;
                            }
                            stream.writeByte(1);
                            continue;
                        }
                        if ("Resource".equals(data.getValueRole()) || parent != null) {
                            stream.writeByte(0);
                            try {
                                ResourceKey resourceKey = ResourceKeyUtils.embedResourceInKey((ResourceManager)this.locateResourceManager(), (ResourceKey)key, (Map)key.getFactoryParameters());
                                SerializerHelper.getInstance().writeObject((Object)resourceKey, stream);
                                continue;
                            }
                            catch (ResourceException e) {
                                throw new IOException("Failed to convert resource-key into byte-array key: " + (Object)((Object)e));
                            }
                        }
                        stream.writeByte(0);
                        SerializerHelper.getInstance().writeObject(attribute, stream);
                        continue;
                    }
                    if (SerializerHelper.getInstance().isSerializable(attribute)) {
                        stream.writeByte(0);
                        SerializerHelper.getInstance().writeObject(attribute, stream);
                        continue;
                    }
                    stream.writeByte(1);
                    continue;
                }
                stream.writeByte(1);
            }
        }
    }

    private boolean isKeySerializable(ResourceKey key) {
        try {
            ObjectOutputStream oout = new ObjectOutputStream(new NullOutputStream());
            oout.writeObject(key);
            oout.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ResourceManager locateResourceManager() {
        ReportDefinition reportDefinition = this.getReportDefinition();
        if (!(reportDefinition instanceof AbstractReportDefinition)) {
            ResourceManager retval = new ResourceManager();
            retval.registerDefaults();
            return retval;
        }
        AbstractReportDefinition abstractReportDefinition = (AbstractReportDefinition)reportDefinition;
        return abstractReportDefinition.getResourceManager();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.attributes = new ReportAttributeMap(stream.readLong());
        String[] nameSpaces = (String[])stream.readObject();
        for (int i = 0; i < nameSpaces.length; ++i) {
            String nameSpace = nameSpaces[i];
            String[] names = (String[])stream.readObject();
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                byte nullHandler = stream.readByte();
                if (nullHandler != 0) continue;
                Object attribute = SerializerHelper.getInstance().readObject(stream);
                this.attributes.setAttribute(nameSpace, name, attribute);
            }
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append(this.getClass().getName());
        b.append("={name=\"");
        b.append(this.getName());
        b.append("\", type=\"");
        b.append(this.getElementTypeName());
        b.append("\"}");
        return b.toString();
    }

    private static class InternalElementStyleSheet
    extends ElementStyleSheet {
        private Element element;
        private Section parent;

        protected InternalElementStyleSheet(Element element) {
            super("internal-stylesheet:element:" + System.identityHashCode(element));
            this.parent = element.getParentSection();
            this.element = element;
            this.setGlobalDefaultStyleSheet(element.createGlobalDefaultStyle());
        }

        public Element getElement() {
            return this.element;
        }

        public Object clone() throws CloneNotSupportedException {
            InternalElementStyleSheet es = (InternalElementStyleSheet)super.clone();
            es.parent = null;
            es.element = null;
            StyleSheetCarrier[] sheets = es.getParentReferences();
            int length = sheets.length;
            for (int i = 0; i < length; ++i) {
                InternalElementStyleSheetCarrier esc = (InternalElementStyleSheetCarrier)sheets[i];
                esc.updateParentReference(es);
            }
            return es;
        }

        public StyleSheet derive() throws CloneNotSupportedException {
            InternalElementStyleSheet es = (InternalElementStyleSheet)super.derive();
            es.parent = null;
            es.element = null;
            StyleSheetCarrier[] sheets = es.getParentReferences();
            int length = sheets.length;
            for (int i = 0; i < length; ++i) {
                InternalElementStyleSheetCarrier esc = (InternalElementStyleSheetCarrier)sheets[i];
                esc.updateParentReference(es);
            }
            return es;
        }

        public void parentChanged() {
            if (this.parent != null) {
                this.setCascadeStyleSheet(null);
            }
            this.parent = this.element.getParentSection();
            if (this.parent != null) {
                this.setCascadeStyleSheet(this.parent.getStyle());
            }
        }

        protected void updateElementReference(Element e) {
            if (e == null) {
                throw new NullPointerException("Invalid implementation: Self reference cannot be null after cloning.");
            }
            this.element = e;
        }

        protected StyleSheetCarrier createCarrier(ElementStyleSheet styleSheet) {
            return new InternalElementStyleSheetCarrier(this, styleSheet);
        }

        public void setStyleProperty(StyleKey key, Object value) {
            long l = this.getChangeTracker();
            Object oldValue = super.isLocalKey(key) ? super.getStyleProperty(key) : null;
            super.setStyleProperty(key, value);
            if (l != this.getChangeTracker()) {
                this.element.notifyNodePropertiesChanged(new StyleChange(key, oldValue, value));
            }
        }
    }

    private static class InternalElementStyleSheetCarrier
    implements StyleSheetCarrier {
        private transient ElementStyleSheet styleSheet;
        private InternalElementStyleSheet self;
        private InstanceID styleSheetID;

        protected InternalElementStyleSheetCarrier(InternalElementStyleSheet parent, ElementStyleSheet styleSheet) {
            if (parent == null) {
                throw new NullPointerException("Internal stylesheet must not be null.");
            }
            if (styleSheet == null) {
                throw new NullPointerException("Inherited stylesheet must not be null.");
            }
            this.self = parent;
            this.styleSheet = styleSheet;
            this.styleSheetID = styleSheet.getId();
        }

        protected void updateParentReference(InternalElementStyleSheet self) {
            if (self == null) {
                throw new NullPointerException("Invalid implementation: Self reference cannot be null after cloning.");
            }
            this.self = self;
        }

        public Object clone() throws CloneNotSupportedException {
            InternalElementStyleSheetCarrier ic = (InternalElementStyleSheetCarrier)super.clone();
            ic.self = null;
            ic.styleSheet = null;
            return ic;
        }

        public ElementStyleSheet getStyleSheet() {
            if (this.styleSheet != null) {
                return this.styleSheet;
            }
            if (this.self == null) {
                throw new IllegalStateException("Stylesheet was not valid after restore operation.");
            }
            Element element = this.self.getElement();
            if (element == null) {
                throw new IllegalStateException();
            }
            ReportDefinition reportDefinition = element.getReportDefinition();
            if (reportDefinition == null) {
                throw new IllegalStateException("Stylesheet was not valid after restore operation: " + this.styleSheetID);
            }
            this.styleSheet = reportDefinition.getStyleSheetCollection().getStyleSheetByID(this.styleSheetID);
            return this.styleSheet;
        }

        public void invalidate() {
            this.styleSheet = null;
        }

        public boolean isSame(ElementStyleSheet style) {
            return style.getId().equals(this.styleSheetID);
        }
    }
}

