/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;

public abstract class Group
extends Section {
    private static final long serialVersionUID = 8309478419800349694L;
    private GroupHeader header;
    private GroupFooter footer = new GroupFooter();
    private GroupBody body;
    public static final String ANONYMOUS_GROUP_PREFIX = "anonymousGroup@";

    protected Group() {
        this.header = new GroupHeader();
        this.body = this.createDefaultBody();
        this.registerAsChild(this.footer);
        this.registerAsChild(this.header);
        this.registerAsChild(this.body);
    }

    public GroupHeader getHeader() {
        return this.header;
    }

    public void setHeader(GroupHeader header) {
        if (header == null) {
            throw new NullPointerException("Header must not be null");
        }
        this.validateLooping(header);
        if (this.unregisterParent(header)) {
            return;
        }
        GroupHeader element = this.header;
        this.header.setParent(null);
        this.header = header;
        this.header.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.header);
    }

    public GroupBody getBody() {
        return this.body;
    }

    public void setBody(GroupBody body) {
        if (body == null) {
            throw new NullPointerException("The body must not be null");
        }
        this.validateLooping(body);
        if (this.unregisterParent(body)) {
            return;
        }
        GroupBody element = this.body;
        this.body.setParent(null);
        this.body = body;
        this.body.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.body);
    }

    public GroupFooter getFooter() {
        return this.footer;
    }

    public void setFooter(GroupFooter footer) {
        if (footer == null) {
            throw new NullPointerException("The footer must not be null");
        }
        this.validateLooping(footer);
        if (this.unregisterParent(footer)) {
            return;
        }
        GroupFooter element = this.footer;
        this.footer.setParent(null);
        this.footer = footer;
        this.footer.setParent(this);
        this.notifyNodeChildRemoved(element);
        this.notifyNodeChildAdded(this.footer);
    }

    public Object clone() throws CloneNotSupportedException {
        Group g = (Group)super.clone();
        g.footer = (GroupFooter)this.footer.clone();
        g.header = (GroupHeader)this.header.clone();
        g.body = (GroupBody)this.body.clone();
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        g.registerAsChild(g.body);
        return g;
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        Group g = (Group)super.derive(preserveElementInstanceIds);
        g.footer = (GroupFooter)this.footer.derive(preserveElementInstanceIds);
        g.header = (GroupHeader)this.header.derive(preserveElementInstanceIds);
        g.body = (GroupBody)this.body.derive(preserveElementInstanceIds);
        g.registerAsChild(g.footer);
        g.registerAsChild(g.header);
        g.registerAsChild(g.body);
        return g;
    }

    public abstract boolean isGroupChange(DataRow var1);

    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (this.footer == element) {
            this.footer.setParent(null);
            this.footer = new GroupFooter();
            this.footer.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.footer);
        } else if (this.header == element) {
            this.header.setParent(null);
            this.header = new GroupHeader();
            this.header.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.header);
        } else if (this.body == element) {
            this.body.setParent(null);
            this.body = this.createDefaultBody();
            this.body.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.body);
        }
    }

    protected abstract GroupBody createDefaultBody();

    public int getElementCount() {
        return 3;
    }

    public ReportElement getElement(int index) {
        switch (index) {
            case 0: {
                return this.header;
            }
            case 1: {
                return this.body;
            }
            case 2: {
                return this.footer;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public void setElementAt(int index, Element element) {
        switch (index) {
            case 0: {
                this.setHeader((GroupHeader)element);
                break;
            }
            case 1: {
                this.setBody((GroupBody)element);
                break;
            }
            case 2: {
                this.setFooter((GroupFooter)element);
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }
}

