/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;

public class GroupList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2193162824440886046L;
    private transient RelationalGroup[] cache;
    private ArrayList backend = new ArrayList();
    public static final String DEFAULT_GROUP_NAME = "default";

    public GroupList() {
        this.createDefaultGroup();
    }

    private void createDefaultGroup() {
        RelationalGroup defaultGroup = new RelationalGroup();
        this.add(defaultGroup);
    }

    protected GroupList(GroupList list) {
        this.backend.addAll(list.backend);
    }

    public Group get(int i) {
        if (this.cache == null) {
            this.cache = this.backend.toArray(new RelationalGroup[this.backend.size()]);
        }
        return this.cache[i];
    }

    public boolean remove(RelationalGroup o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.cache = null;
        int idxOf = this.backend.indexOf(o);
        if (idxOf == -1) {
            return false;
        }
        this.backend.remove(idxOf);
        if (this.backend.isEmpty()) {
            this.createDefaultGroup();
        }
        return true;
    }

    public void clear() {
        this.backend.clear();
        this.createDefaultGroup();
        this.cache = null;
    }

    public void add(RelationalGroup o) {
        if (o == null) {
            throw new NullPointerException("Try to add null");
        }
        this.cache = null;
        int idxOf = this.backend.indexOf(o);
        if (idxOf != -1) {
            this.backend.remove(idxOf);
        }
        for (int i = 0; i < this.backend.size(); ++i) {
            RelationalGroup compareGroup = (RelationalGroup)this.backend.get(i);
            if (this.compareGroups(compareGroup, o) <= 0) continue;
            this.backend.add(i, o);
            return;
        }
        this.backend.add(o);
    }

    public void addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add((RelationalGroup)it.next());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GroupList l = (GroupList)super.clone();
        RelationalGroup[] groups = this.getGroupCache();
        l.backend = (ArrayList)this.backend.clone();
        l.backend.clear();
        int length = groups.length;
        l.cache = new RelationalGroup[length];
        for (int i = 0; i < length; ++i) {
            RelationalGroup group = (RelationalGroup)groups[i].clone();
            l.backend.add(group);
            l.cache[i] = group;
        }
        return l;
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(this.backend).iterator();
    }

    public int size() {
        return this.backend.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GroupList={backend='");
        b.append(this.backend);
        b.append("'} ");
        return b.toString();
    }

    protected RelationalGroup[] getGroupCache() {
        if (this.cache == null) {
            this.cache = this.backend.toArray(new RelationalGroup[this.backend.size()]);
        }
        return this.cache;
    }

    public Group getGroupByName(String name) {
        if (name == null) {
            return null;
        }
        RelationalGroup[] cache = this.getGroupCache();
        int length = cache.length;
        for (int i = 0; i < length; ++i) {
            if (!name.equals(cache[i].getName())) continue;
            return cache[i];
        }
        return null;
    }

    public Group constructRootGroup() {
        RelationalGroup rootGroup;
        RelationalGroup[] cache = this.getGroupCache();
        if (cache.length == 0) {
            return new RelationalGroup();
        }
        GroupDataBody dataBody = null;
        RelationalGroup currentGroup = rootGroup = cache[0];
        for (int i = 1; i < cache.length; ++i) {
            RelationalGroup g = cache[i];
            GroupBody body = currentGroup.getBody();
            if (body instanceof SubGroupBody) {
                SubGroupBody sbody = (SubGroupBody)body;
                sbody.setGroup(g);
            } else {
                dataBody = (GroupDataBody)currentGroup.getBody();
                ((Group)currentGroup).setBody(new SubGroupBody(g));
            }
            currentGroup = g;
        }
        if (dataBody != null) {
            ((Group)currentGroup).setBody(dataBody);
        }
        return rootGroup;
    }

    private int compareGroups(RelationalGroup g1, RelationalGroup g2) {
        List fieldsGroup1 = g1.getFields();
        List fieldsGroup2 = g2.getFields();
        if (fieldsGroup1.size() == fieldsGroup2.size()) {
            if (fieldsGroup1.containsAll(fieldsGroup2)) {
                return 0;
            }
            throw new IllegalArgumentException("These groups are not comparable, as they don't have any subgroup relation.  Groups of the same GroupList must have a subgroup relation. The designated  child group must contain all fields of the direct parent plus at least one  new field.");
        }
        if (fieldsGroup1.containsAll(fieldsGroup2)) {
            return 1;
        }
        if (fieldsGroup2.containsAll(fieldsGroup1)) {
            return -1;
        }
        throw new IllegalArgumentException("These groups are not comparable, as they don't have any subgroup relation.  Groups of the same GroupList must have a subgroup relation. The designated  child group must contain all fields of the direct parent plus at least one  new field.");
    }
}

