/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ExtendedResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.designtime.AttributeChange;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.event.ReportModelListener;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.MasterReportType;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.LibLoaderResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class MasterReport
extends AbstractReportDefinition {
    private static final Log logger = LogFactory.getLog(MasterReport.class);
    public static final String NAME_PROPERTY = "report.name";
    public static final String REPORT_DATE_PROPERTY = "report.date";
    private DataFactory dataFactory;
    private ModifiableConfiguration reportConfiguration;
    private transient ResourceManager resourceManager;
    private ReportParameterDefinition parameterDefinition;
    private ReportEnvironment reportEnvironment;
    private ReportParameterValues parameterValues;

    public MasterReport() {
        this.setElementType(new MasterReportType());
        this.setResourceBundleFactory(new LibLoaderResourceBundleFactory());
        this.reportConfiguration = new HierarchicalConfiguration(ClassicEngineBoot.getInstance().getGlobalConfig());
        this.parameterValues = new ReportParameterValues();
        this.setPageDefinition(null);
        TableDataFactory dataFactory = new TableDataFactory();
        dataFactory.addTable("default", new DefaultTableModel());
        this.dataFactory = dataFactory;
        this.setQuery("default");
        this.addReportModelListener(new DocumentBundleChangeHandler());
        this.reportEnvironment = new DefaultReportEnvironment(this.getConfiguration());
        this.parameterDefinition = new DefaultParameterDefinition();
        MemoryDocumentBundle documentBundle = new MemoryDocumentBundle();
        documentBundle.getWriteableDocumentMetaData().setBundleType("application/vnd.pentaho.reporting.classic");
        documentBundle.getWriteableDocumentMetaData().setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date", (Object)new Date());
        this.setBundle((DocumentBundle)documentBundle);
        this.setContentBase(documentBundle.getBundleMainKey());
    }

    public void setResourceBundleFactory(ResourceBundleFactory resourceBundleFactory) {
        if (resourceBundleFactory == null) {
            throw new NullPointerException("ResourceBundleFactory must not be null");
        }
        super.setResourceBundleFactory(resourceBundleFactory);
    }

    public DocumentBundle getBundle() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "bundle");
        if (o instanceof DocumentBundle) {
            return (DocumentBundle)o;
        }
        return null;
    }

    public void setBundle(DocumentBundle bundle) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "bundle", bundle);
    }

    public ReportParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    public void setParameterDefinition(ReportParameterDefinition parameterDefinition) {
        if (parameterDefinition == null) {
            throw new NullPointerException();
        }
        this.parameterDefinition = parameterDefinition;
        this.notifyNodePropertiesChanged();
    }

    public ReportEnvironment getReportEnvironment() {
        return this.reportEnvironment;
    }

    public void setReportEnvironment(ReportEnvironment reportEnvironment) {
        if (reportEnvironment == null) {
            throw new NullPointerException();
        }
        this.reportEnvironment = reportEnvironment;
        this.notifyNodePropertiesChanged();
    }

    public String getTitle() {
        Object o;
        DocumentBundle bundle = this.getBundle();
        if (bundle != null && (o = bundle.getMetaData().getBundleAttribute("http://purl.org/dc/elements/1.1/", "title")) != null) {
            return o.toString();
        }
        return null;
    }

    public String getName() {
        Object nameFromProperties = this.getProperty(NAME_PROPERTY);
        if (nameFromProperties == null) {
            return super.getName();
        }
        return String.valueOf(nameFromProperties);
    }

    public void setName(String name) {
        super.setName(name);
        super.setProperty(NAME_PROPERTY, name);
    }

    public PageDefinition getPageDefinition() {
        PageDefinition pageDefinition = (PageDefinition)this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "page-definition");
        if (pageDefinition == null) {
            return this.createDefaultPageDefinition();
        }
        return pageDefinition;
    }

    public void setPageDefinition(PageDefinition format) {
        if (format == null) {
            format = this.createDefaultPageDefinition();
        }
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "page-definition", format);
        this.notifyNodePropertiesChanged();
    }

    private PageDefinition createDefaultPageDefinition() {
        ExtendedConfiguration config = ClassicEngineBoot.getInstance().getExtendedConfig();
        SimplePageDefinition format = config.getBoolProperty("org.pentaho.reporting.engine.classic.core.NoPrinterAvailable") ? new SimplePageDefinition(new PageFormat()) : new SimplePageDefinition(PrinterJob.getPrinterJob().defaultPage());
        return format;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDataFactory(DataFactory dataFactory) {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        DataFactory old = this.dataFactory;
        this.dataFactory = dataFactory;
        this.notifyNodeChildRemoved(old);
        this.notifyNodeChildAdded(dataFactory);
    }

    public Object clone() throws CloneNotSupportedException {
        MasterReport report = (MasterReport)super.clone();
        report.reportConfiguration = (ModifiableConfiguration)this.reportConfiguration.clone();
        report.reportEnvironment = (ReportEnvironment)this.reportEnvironment.clone();
        if (report.reportEnvironment instanceof DefaultReportEnvironment) {
            DefaultReportEnvironment dre = (DefaultReportEnvironment)report.reportEnvironment;
            dre.update((Configuration)report.reportConfiguration);
        }
        report.parameterDefinition = (ReportParameterDefinition)this.parameterDefinition.clone();
        report.parameterValues = (ReportParameterValues)this.parameterValues.clone();
        report.dataFactory = this.dataFactory.derive();
        report.addReportModelListener(new DocumentBundleChangeHandler());
        return report;
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        MasterReport report = (MasterReport)super.derive(preserveElementInstanceIds);
        report.reportConfiguration = (ModifiableConfiguration)this.reportConfiguration.clone();
        report.reportEnvironment = (ReportEnvironment)this.reportEnvironment.clone();
        if (report.reportEnvironment instanceof DefaultReportEnvironment) {
            DefaultReportEnvironment dre = (DefaultReportEnvironment)report.reportEnvironment;
            dre.update((Configuration)report.reportConfiguration);
        }
        report.parameterDefinition = (ReportParameterDefinition)this.parameterDefinition.clone();
        report.parameterValues = (ReportParameterValues)this.parameterValues.clone();
        report.dataFactory = this.dataFactory.derive();
        report.addReportModelListener(new DocumentBundleChangeHandler());
        return report;
    }

    public ModifiableConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public Configuration getConfiguration() {
        return this.reportConfiguration;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
            this.updateResourceBundleFactory();
        }
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.notifyNodePropertiesChanged();
    }

    public ReportParameterValues getParameterValues() {
        return this.parameterValues;
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value);
        logger.warn((Object)"Use of deprecated features: Do not use Report-Properties, use the parameter-values directly.");
        this.parameterValues.put(key, value);
    }

    protected void updateChangedFlagInternal(ReportElement element, int type, Object parameter) {
        this.fireModelLayoutChanged(element, type, parameter);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.getBundle() == null) {
            MemoryDocumentBundle documentBundle = new MemoryDocumentBundle(this.getContentBase());
            documentBundle.getWriteableDocumentMetaData().setBundleType("application/vnd.pentaho.reporting.classic");
            documentBundle.getWriteableDocumentMetaData().setBundleAttribute("urn:oasis:names:tc:opendocument:xmlns:meta:1.0", "creation-date", (Object)new Date());
            this.setBundle((DocumentBundle)documentBundle);
            this.setContentBase(documentBundle.getBundleMainKey());
            this.setResourceManager(documentBundle.getResourceManager());
        }
        this.addReportModelListener(new DocumentBundleChangeHandler());
    }

    public static ResourceBundleFactory computeAndInitResourceBundleFactory(ResourceBundleFactory resourceBundleFactory, ReportEnvironment environment) throws ReportProcessingException {
        if (!(resourceBundleFactory instanceof ExtendedResourceBundleFactory)) {
            return resourceBundleFactory;
        }
        ExtendedResourceBundleFactory rawResourceBundleFactory = (ExtendedResourceBundleFactory)resourceBundleFactory;
        try {
            ExtendedResourceBundleFactory extendedResourceBundleFactory = (ExtendedResourceBundleFactory)rawResourceBundleFactory.clone();
            if (extendedResourceBundleFactory.getLocale() == null) {
                extendedResourceBundleFactory.setLocale(environment.getLocale());
            }
            if (extendedResourceBundleFactory.getTimeZone() == null) {
                extendedResourceBundleFactory.setTimeZone(environment.getTimeZone());
            }
            return extendedResourceBundleFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportProcessingException("Cannot clone resource-bundle factory");
        }
    }

    public Integer getCompatibilityLevel() {
        Object definedCompatLevel = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "compatibility-level");
        if (definedCompatLevel instanceof Integer) {
            return (Integer)definedCompatLevel;
        }
        return null;
    }

    public void setCompatibilityLevel(Integer level) {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "compatibility-level", level);
    }

    public void updateLegacyConfiguration() {
    }

    private static class DocumentBundleChangeHandler
    implements ReportModelListener {
        private static final Log log = LogFactory.getLog(DocumentBundleChangeHandler.class);

        private DocumentBundleChangeHandler() {
        }

        public void nodeChanged(ReportModelEvent event) {
            if (!(event.getParameter() instanceof AttributeChange) || !(event.getElement() instanceof MasterReport)) {
                return;
            }
            AttributeChange attributeChange = (AttributeChange)event.getParameter();
            if ("http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(attributeChange.getNamespace()) && "bundle".equals(attributeChange.getName())) {
                Object value = attributeChange.getNewValue();
                if (!(value instanceof DocumentBundle)) {
                    return;
                }
                if (event.getElement() instanceof MasterReport) {
                    log.debug((Object)"DocumentBundle change detected - changing the ResourceManager for the MasterReport");
                    MasterReport report = (MasterReport)event.getElement();
                    DocumentBundle newDocumentBundle = (DocumentBundle)value;
                    ResourceManager resourceManager = newDocumentBundle.getResourceManager();
                    report.setResourceManager(resourceManager);
                } else {
                    log.warn((Object)"Could not replace the ResourceKey on a DocumentBundle change - the element is not a MasterReport");
                }
            }
        }
    }
}

