/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.PageHeaderType;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;

public class PageHeader
extends Band
implements RootLevelBand {
    private static final SubReport[] EMPTY_SUB_REPORTS = new SubReport[0];

    public PageHeader() {
        this.setElementType(new PageHeaderType());
    }

    public PageHeader(boolean onFirstPage, boolean onLastPage) {
        this.setDisplayOnFirstPage(onFirstPage);
        this.setDisplayOnLastPage(onLastPage);
    }

    public boolean isDisplayOnFirstPage() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE);
    }

    public void setDisplayOnFirstPage(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, b);
        this.notifyNodePropertiesChanged();
    }

    public boolean isDisplayOnLastPage() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE);
    }

    public void setDisplayOnLastPage(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, b);
        this.notifyNodePropertiesChanged();
    }

    public final int getSubReportCount() {
        return 0;
    }

    public final SubReport getSubReport(int index) {
        throw new IndexOutOfBoundsException("PageHeader cannot have subreports");
    }

    public boolean isSticky() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.STICKY, false);
    }

    public void setSticky(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.STICKY, b);
        this.notifyNodePropertiesChanged();
    }

    public SubReport[] getSubReports() {
        return EMPTY_SUB_REPORTS;
    }
}

