/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.RelationalGroupType;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class RelationalGroup
extends Group {
    private static final String[] EMPTY_FIELDS = new String[0];

    public RelationalGroup() {
        this.setElementType(new RelationalGroupType());
    }

    public void setFields(List c) {
        if (c == null) {
            throw new NullPointerException();
        }
        String[] fields = c.toArray(new String[c.size()]);
        this.setFieldsArray(fields);
    }

    public void clearFields() {
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields", EMPTY_FIELDS);
    }

    protected GroupBody createDefaultBody() {
        return new GroupDataBody();
    }

    public void addField(String name) {
        if (name == null) {
            throw new NullPointerException("Group.addField(...): name is null.");
        }
        ArrayList<String> fieldsList = new ArrayList<String>(this.getFields());
        fieldsList.add(name);
        Collections.sort(fieldsList);
        this.setFieldsArray(fieldsList.toArray(new String[fieldsList.size()]));
    }

    public List getFields() {
        return Collections.unmodifiableList(Arrays.asList(this.getFieldsArray()));
    }

    public void setFieldsArray(String[] fields) {
        if (fields == null) {
            throw new NullPointerException();
        }
        this.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields", fields.clone());
    }

    public String[] getFieldsArray() {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields");
        if (o instanceof String[]) {
            String[] fields = (String[])o;
            return (String[])fields.clone();
        }
        return EMPTY_FIELDS;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(120);
        b.append("DefaultGroup={Name='");
        b.append(this.getName());
        b.append("', fields=");
        b.append(this.getFields());
        b.append("} ");
        return b.toString();
    }

    public void setBody(GroupBody body) {
        if (!(body instanceof GroupDataBody) && !(body instanceof SubGroupBody)) {
            throw new IllegalArgumentException();
        }
        super.setBody(body);
    }

    public boolean equals(Object obj) {
        Object[] myFields;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelationalGroup)) {
            return false;
        }
        RelationalGroup group = (RelationalGroup)obj;
        Object[] otherFields = group.getFieldsArray();
        return ObjectUtilities.equalArray((Object[])otherFields, (Object[])(myFields = this.getFieldsArray()));
    }

    public int hashCode() {
        String[] fields = this.getFieldsArray();
        int hashCode = 0;
        for (String field : fields) {
            hashCode = field == null ? 29 * hashCode : 29 * hashCode + field.hashCode();
        }
        return hashCode;
    }

    public boolean isGroupChange(DataRow dataRow) {
        Object o = this.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "group-fields");
        if (o instanceof String[]) {
            String[] fields = (String[])o;
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i];
                if (field == null || !dataRow.isChanged(field)) continue;
                return true;
            }
        }
        return false;
    }
}

