/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ReportEnvironmentDataRow
implements DataRow {
    private static final String ENV_MAPPING_KEY_PREFIX = "org.pentaho.reporting.engine.classic.core.env-mapping.";
    private ReportEnvironment environment;
    private LinkedHashMap<String, String> columnMap;

    public ReportEnvironmentDataRow(ReportEnvironment environment) {
        LinkedMap envMapping = ReportEnvironmentDataRow.createEnvironmentMapping();
        this.columnMap = new LinkedHashMap();
        Object[] keys = envMapping.keys();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = (String)envMapping.get((Object)key);
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) continue;
            this.columnMap.put(value, key);
        }
        this.environment = environment;
    }

    public Object get(String col) {
        String envName = this.columnMap.get(col);
        if (envName == null) {
            return null;
        }
        if (envName.endsWith("-array")) {
            String name = envName.substring(0, envName.length() - 6);
            String s = this.environment.getEnvironmentProperty(name);
            if (s == null) {
                return new String[0];
            }
            CSVTokenizer csvTokenizer = new CSVTokenizer(s, ",", "\"", false);
            int length = csvTokenizer.countTokens();
            String[] rolesArray = new String[length];
            for (int i = 0; i < length; ++i) {
                rolesArray[i] = csvTokenizer.nextToken();
            }
            return rolesArray;
        }
        return this.environment.getEnvironmentProperty(envName);
    }

    public String[] getColumnNames() {
        return this.columnMap.keySet().toArray(new String[this.columnMap.size()]);
    }

    public boolean isChanged(String name) {
        return false;
    }

    public boolean isArray(String columnName) {
        String envName = this.columnMap.get(columnName);
        if (envName == null) {
            return false;
        }
        return envName.endsWith("-array");
    }

    public boolean isRolesArray(String columnName) {
        return this.isArray(columnName);
    }

    public static LinkedMap createEnvironmentMapping() {
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator propertyKeys = configuration.findPropertyKeys(ENV_MAPPING_KEY_PREFIX);
        LinkedMap names = new LinkedMap();
        while (propertyKeys.hasNext()) {
            String key = (String)propertyKeys.next();
            String value = configuration.getConfigProperty(key);
            String shortKey = key.substring(ENV_MAPPING_KEY_PREFIX.length());
            names.put((Object)shortKey, (Object)value);
        }
        return names;
    }

    public ReportEnvironment getEnvironment() {
        return this.environment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReportEnvironmentDataRow");
        sb.append("{columnMap=").append(this.columnMap);
        sb.append('}');
        return sb.toString();
    }
}

