/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;

public class ReportEventException
extends ReportProcessingException {
    private List childExceptions;

    public ReportEventException(String message, List childExceptions) {
        super(message);
        if (childExceptions == null) {
            throw new NullPointerException();
        }
        this.childExceptions = Collections.unmodifiableList(childExceptions);
    }

    public List getChildExceptions() {
        return this.childExceptions;
    }

    public String getMessage() {
        return super.getMessage() + ": " + this.childExceptions.size() + " exceptions occured.";
    }

    public void printStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
        for (int i = 0; i < this.childExceptions.size(); ++i) {
            writer.print("Exception #");
            writer.println(i);
            Exception ex = (Exception)this.childExceptions.get(i);
            if (ex != null) {
                ex.printStackTrace(writer);
                continue;
            }
            writer.println("<not defined>");
        }
    }

    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        for (int i = 0; i < this.childExceptions.size(); ++i) {
            stream.print("Exception #");
            stream.println(i);
            Exception ex = (Exception)this.childExceptions.get(i);
            if (ex != null) {
                ex.printStackTrace(stream);
                continue;
            }
            stream.println("<not defined>");
        }
    }
}

