/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;

public class ShapeElement
extends Element {
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(0.5f);
    public static final StyleKey FILL_SHAPE = ElementStyleKeys.FILL_SHAPE;
    public static final StyleKey DRAW_SHAPE = ElementStyleKeys.DRAW_SHAPE;

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ShapeElement={ name=");
        b.append(this.getName());
        b.append('}');
        return b.toString();
    }

    public boolean isShouldDraw() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.DRAW_SHAPE);
    }

    public boolean isShouldFill() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE);
    }

    public void setShouldDraw(boolean shouldDraw) {
        this.getStyle().setStyleProperty(ElementStyleKeys.DRAW_SHAPE, shouldDraw ? Boolean.TRUE : Boolean.FALSE);
        this.notifyNodePropertiesChanged();
    }

    public void setShouldFill(boolean shouldFill) {
        this.getStyle().setStyleProperty(ElementStyleKeys.FILL_SHAPE, shouldFill ? Boolean.TRUE : Boolean.FALSE);
        this.notifyNodePropertiesChanged();
    }

    public boolean isScale() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.SCALE);
    }

    public void setScale(boolean scale) {
        this.getStyle().setStyleProperty(ElementStyleKeys.SCALE, scale ? Boolean.TRUE : Boolean.FALSE);
        this.notifyNodePropertiesChanged();
    }

    public boolean isKeepAspectRatio() {
        return this.getStyle().getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
    }

    public void setKeepAspectRatio(boolean kar) {
        this.getStyle().setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, kar ? Boolean.TRUE : Boolean.FALSE);
        this.notifyNodePropertiesChanged();
    }

    public Stroke getStroke() {
        return (Stroke)this.getStyle().getStyleProperty(ElementStyleKeys.STROKE);
    }

    public void setStroke(Stroke stroke) {
        this.getStyle().setStyleProperty(ElementStyleKeys.STROKE, stroke);
        this.notifyNodePropertiesChanged();
    }
}

