/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class StaticDataRow
implements DataRow {
    private static final String[] EMPTY_NAMES = new String[0];
    private String[] names;
    private Map<String, Object> values;

    public StaticDataRow() {
        this.values = Collections.emptyMap();
        this.names = EMPTY_NAMES;
    }

    protected StaticDataRow(StaticDataRow dataRow) {
        if (dataRow == null) {
            throw new NullPointerException();
        }
        this.names = dataRow.names;
        this.values = dataRow.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StaticDataRow(DataRow dataRow) {
        if (dataRow == null) {
            throw new NullPointerException();
        }
        DataRow dataRow2 = dataRow;
        synchronized (dataRow2) {
            String[] columnNames = dataRow.getColumnNames();
            int columnCount = columnNames.length;
            this.names = (String[])columnNames.clone();
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int i = 0; i < columnCount; ++i) {
                String name = columnNames[i];
                values.put(name, dataRow.get(name));
            }
            this.values = Collections.unmodifiableMap(values);
        }
    }

    public StaticDataRow(String[] names, Object[] values) {
        this.setData(names, values);
    }

    public String[] getColumnNames() {
        if (this.names == null) {
            return EMPTY_NAMES;
        }
        return (String[])this.names.clone();
    }

    protected void setData(String[] names, Object[] values) {
        if (names == null) {
            throw new NullPointerException();
        }
        if (values == null) {
            throw new NullPointerException();
        }
        if (names.length == values.length) {
            this.names = (String[])names.clone();
            int length = names.length;
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            for (int i = 0; i < length; ++i) {
                String name = names[i];
                valueMap.put(name, values[i]);
            }
            this.values = Collections.unmodifiableMap(valueMap);
        } else {
            int length = Math.min(names.length, values.length);
            this.names = new String[length];
            System.arraycopy(names, 0, this.names, 0, length);
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            for (int i = 0; i < length; ++i) {
                String name = names[i];
                valueMap.put(name, values[i]);
            }
            this.values = Collections.unmodifiableMap(valueMap);
        }
    }

    protected void updateData(Object[] values) {
        if (values.length != this.values.size()) {
            throw new IllegalArgumentException("You should preserve the number of columns.");
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        int length = Math.min(this.names.length, values.length);
        for (int i = 0; i < length; ++i) {
            String name = this.names[i];
            valueMap.put(name, values[i]);
        }
        this.values = Collections.unmodifiableMap(valueMap);
    }

    public Object get(String col) {
        return this.values.get(col);
    }

    public boolean isChanged(String name) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticDataRow)) {
            return false;
        }
        StaticDataRow that = (StaticDataRow)o;
        if (!Arrays.equals(this.names, that.names)) {
            return false;
        }
        return this.equalsMap(that.values);
    }

    public int hashCode() {
        int result = this.hashCodeMap();
        for (int i = 0; i < this.names.length; ++i) {
            String name = this.names[i];
            result = name != null ? 31 * result + name.hashCode() : 31 * result;
        }
        return result;
    }

    private boolean equalsMap(Map otherValues) {
        if (otherValues.size() != this.values.size()) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            String key = this.names[i];
            Object value = this.values.get(key);
            Object otherValue = otherValues.get(key);
            if (value == null && otherValue == null || !(value instanceof Object[] && otherValue instanceof Object[] ? !ObjectUtilities.equalArray((Object[])((Object[])value), (Object[])((Object[])otherValue)) : !ObjectUtilities.equal((Object)value, otherValue))) continue;
            return false;
        }
        return true;
    }

    private int hashCodeMap() {
        int hashCode = this.values.size();
        for (int i = 0; i < this.names.length; ++i) {
            String key = this.names[i];
            Object value = this.values.get(key);
            hashCode = 31 * hashCode + (key != null ? key.hashCode() : 0);
            hashCode = value == null ? 31 * hashCode : (value instanceof Object[] ? 31 * hashCode + ObjectUtilities.hashCode((Object[])((Object[])value)) : 31 * hashCode + value.hashCode());
        }
        return hashCode;
    }
}

