/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubGroupBodyType;

public class SubGroupBody
extends GroupBody {
    private Group group;

    public SubGroupBody() {
        this.setElementType(new SubGroupBodyType());
        this.group = new RelationalGroup();
        this.registerAsChild(this.group);
    }

    public SubGroupBody(Group group) {
        this();
        this.setGroup(group);
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        if (group == null) {
            throw new NullPointerException("The group must not be null");
        }
        if (!(group instanceof RelationalGroup) && !(group instanceof CrosstabGroup)) {
            throw new NullPointerException("The group must be one of relational-group or crosstab.");
        }
        this.validateLooping(group);
        if (this.unregisterParent(group)) {
            return;
        }
        Group oldGroup = this.group;
        this.group.setParent(null);
        this.group = group;
        this.group.setParent(this);
        this.notifyNodeChildRemoved(oldGroup);
        this.notifyNodeChildAdded(this.group);
    }

    protected void removeElement(Element element) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (element == this.group) {
            this.group.setParent(null);
            this.group = new RelationalGroup();
            this.group.setParent(this);
            this.notifyNodeChildRemoved(element);
            this.notifyNodeChildAdded(this.group);
        }
    }

    public void setElementAt(int position, Element element) {
        if (position != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setGroup((Group)element);
    }

    public int getElementCount() {
        return 1;
    }

    public ReportElement getElement(int index) {
        if (index == 0) {
            return this.group;
        }
        throw new IndexOutOfBoundsException();
    }

    public Object clone() throws CloneNotSupportedException {
        SubGroupBody o = (SubGroupBody)super.clone();
        o.group = (Group)this.group.clone();
        o.registerAsChild(o.group);
        return o;
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        SubGroupBody o = (SubGroupBody)super.derive(preserveElementInstanceIds);
        o.group = (Group)this.group.derive(preserveElementInstanceIds);
        o.registerAsChild(o.group);
        return o;
    }
}

