/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.awt.print.PageFormat;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.designtime.Change;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.SubReportType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class SubReport
extends AbstractReportDefinition {
    private LinkedMap exportParameters;
    private LinkedMap inputParameters;
    private DataFactory dataFactory;

    public SubReport() {
        this.setElementType(new SubReportType());
        this.exportParameters = new LinkedMap();
        this.inputParameters = new LinkedMap();
    }

    public SubReport(InstanceID id) {
        super(id);
        this.setElementType(new SubReportType());
        this.exportParameters = new LinkedMap();
        this.inputParameters = new LinkedMap();
    }

    public PageDefinition getPageDefinition() {
        for (Section parent = this.getParentSection(); parent != null; parent = parent.getParentSection()) {
            if (!(parent instanceof MasterReport)) continue;
            MasterReport masterReport = (MasterReport)parent;
            return masterReport.getPageDefinition();
        }
        return new SimplePageDefinition(new PageFormat());
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        SubReport o = (SubReport)super.derive(preserveElementInstanceIds);
        o.exportParameters = (LinkedMap)this.exportParameters.clone();
        o.inputParameters = (LinkedMap)this.inputParameters.clone();
        if (this.dataFactory != null) {
            o.dataFactory = this.dataFactory.derive();
        }
        return o;
    }

    public Object clone() throws CloneNotSupportedException {
        SubReport o = (SubReport)super.clone();
        o.exportParameters = (LinkedMap)this.exportParameters.clone();
        o.inputParameters = (LinkedMap)this.inputParameters.clone();
        if (this.dataFactory != null) {
            o.dataFactory = this.dataFactory.derive();
        }
        return o;
    }

    public void addExportParameter(String outerName, String sourceColumn) {
        if (outerName == null) {
            throw new NullPointerException();
        }
        if (sourceColumn == null) {
            throw new NullPointerException();
        }
        this.exportParameters.put((Object)outerName, (Object)sourceColumn);
        this.notifyNodePropertiesChanged();
    }

    public void removeExportParameter(String outerName) {
        if (outerName == null) {
            throw new NullPointerException();
        }
        this.exportParameters.remove((Object)outerName);
        this.notifyNodePropertiesChanged();
    }

    public ParameterMapping[] getExportMappings() {
        int length = this.exportParameters.size();
        String[] keys = (String[])this.exportParameters.keys((Object[])new String[length]);
        ParameterMapping[] mapping = new ParameterMapping[length];
        for (int i = 0; i < length; ++i) {
            String name = keys[i];
            String alias = (String)this.exportParameters.get((Object)name);
            mapping[i] = new ParameterMapping(name, alias);
        }
        return mapping;
    }

    public void setExportMappings(ParameterMapping[] mappings) {
        if (mappings == null) {
            throw new NullPointerException();
        }
        this.exportParameters.clear();
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            this.exportParameters.put((Object)mapping.getName(), (Object)mapping.getAlias());
        }
        this.notifyNodePropertiesChanged();
    }

    public void addInputParameter(String outerName, String sourceColumn) {
        if (outerName == null) {
            throw new NullPointerException();
        }
        if (sourceColumn == null) {
            throw new NullPointerException();
        }
        this.inputParameters.put((Object)sourceColumn, (Object)outerName);
        this.notifyNodePropertiesChanged();
    }

    public void removeInputParameter(String sourceColumn) {
        if (sourceColumn == null) {
            throw new NullPointerException();
        }
        this.inputParameters.remove((Object)sourceColumn);
        this.notifyNodePropertiesChanged();
    }

    public void clearInputParameters() {
        this.inputParameters.clear();
        this.notifyNodePropertiesChanged();
    }

    public void clearExportParameters() {
        this.exportParameters.clear();
        this.notifyNodePropertiesChanged();
    }

    public ParameterMapping[] getInputMappings() {
        int length = this.inputParameters.size();
        String[] keys = (String[])this.inputParameters.keys((Object[])new String[length]);
        ParameterMapping[] mapping = new ParameterMapping[length];
        for (int i = 0; i < length; ++i) {
            String alias = keys[i];
            String name = (String)this.inputParameters.get((Object)alias);
            mapping[i] = new ParameterMapping(name, alias);
        }
        return mapping;
    }

    public void setInputMappings(ParameterMapping[] mappings) {
        if (mappings == null) {
            throw new NullPointerException();
        }
        this.inputParameters.clear();
        for (int i = 0; i < mappings.length; ++i) {
            ParameterMapping mapping = mappings[i];
            this.inputParameters.put((Object)mapping.getAlias(), (Object)mapping.getName());
        }
        this.notifyNodePropertiesChanged();
    }

    public boolean isGlobalImport() {
        return "*".equals(this.inputParameters.get((Object)"*"));
    }

    public boolean isGlobalExport() {
        return "*".equals(this.exportParameters.get((Object)"*"));
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void setDataFactory(DataFactory dataFactory) {
        DataFactory old = this.dataFactory;
        this.dataFactory = dataFactory;
        if (old != null) {
            this.notifyNodeChildRemoved(old);
        }
        if (dataFactory != null) {
            this.notifyNodeChildAdded(dataFactory);
        }
    }

    public Expression getActivationExpression() {
        return this.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "subreport-active");
    }

    public void setActivationExpression(Expression activationExpression) {
        this.setAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "subreport-active", activationExpression);
    }

    protected void updateChangedFlagInternal(ReportElement element, int type, Object parameter) {
        super.fireModelLayoutChanged(element, type, parameter);
        if (type == 0 && element == this && parameter instanceof Change) {
            super.updateChangedFlagInternal(element, type, parameter);
        }
    }

    public ResourceManager getResourceManager() {
        for (Section parent = this.getParentSection(); parent != null; parent = parent.getParentSection()) {
            if (!(parent instanceof MasterReport)) continue;
            MasterReport masterReport = (MasterReport)parent;
            return masterReport.getResourceManager();
        }
        ResourceManager manager = new ResourceManager();
        manager.registerDefaults();
        return manager;
    }
}

