/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.HashMap;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class TableDataFactory
implements DataFactory,
Cloneable {
    private static final long serialVersionUID = -238954878318943053L;
    private HashMap<String, TableModel> tables = new HashMap();

    public TableDataFactory() {
    }

    public TableDataFactory(String name, TableModel tableModel) {
        this();
        this.addTable(name, tableModel);
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.tables.containsKey(query);
    }

    public void addTable(String name, TableModel tableModel) {
        if (tableModel == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.tables.put(name, tableModel);
    }

    public void removeTable(String name) {
        this.tables.remove(name);
    }

    public TableModel getTable(String name) {
        return this.tables.get(name);
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        TableModel tableModel = this.tables.get(query);
        if (tableModel == null) {
            throw new ReportDataFactoryException("The specified query '" + query + "' is not recognized.");
        }
        return tableModel;
    }

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
    }

    public void open() {
    }

    public void close() {
    }

    public DataFactory derive() {
        return (DataFactory)this.clone();
    }

    public Object clone() {
        try {
            TableDataFactory dataFactory = (TableDataFactory)super.clone();
            dataFactory.tables = (HashMap)this.tables.clone();
            return dataFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String[] getQueryNames() {
        return this.tables.keySet().toArray(new String[this.tables.size()]);
    }

    public void cancelRunningQuery() {
    }
}

