/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.StringFilter;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public class TextElement
extends Element {
    public static final String CONTENT_TYPE = "text/plain";
    private StringFilter stringfilter = new StringFilter();

    public TextElement() {
        this.setNullString(null);
    }

    public String getNullString() {
        return this.stringfilter.getNullValue();
    }

    public void setNullString(String s) {
        String nstring = s == null ? "-" : s;
        this.stringfilter.setNullValue(nstring);
        this.notifyNodePropertiesChanged();
    }

    public final Object getValue(ExpressionRuntime runtime) {
        this.stringfilter.setDataSource(this.getDataSource());
        return this.stringfilter.getValue(runtime, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(100);
        b.append(this.getClass().getName());
        b.append("={ name=");
        b.append(this.getName());
        b.append(", font=");
        b.append(this.getStyle().getFontDefinitionProperty());
        b.append('}');
        return b.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        TextElement te = (TextElement)super.clone();
        te.stringfilter = (StringFilter)this.stringfilter.clone();
        return te;
    }

    public Element derive(boolean preserveElementInstanceIds) throws CloneNotSupportedException {
        TextElement te = (TextElement)super.derive();
        te.stringfilter = (StringFilter)this.stringfilter.clone();
        return te;
    }

    public String getFontName() {
        return (String)this.getStyle().getStyleProperty(TextStyleKeys.FONT);
    }

    public void setFontName(String fontName) {
        this.getStyle().setStyleProperty(TextStyleKeys.FONT, fontName);
        this.notifyNodePropertiesChanged();
    }

    public int getFontSize() {
        Integer i = (Integer)this.getStyle().getStyleProperty(TextStyleKeys.FONTSIZE);
        return i;
    }

    public void setFontSize(int fontSize) {
        this.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, new Integer(fontSize));
        this.notifyNodePropertiesChanged();
    }

    public boolean isBold() {
        return this.getStyle().getBooleanStyleProperty(TextStyleKeys.BOLD);
    }

    public void setBold(boolean bold) {
        this.getStyle().setBooleanStyleProperty(TextStyleKeys.BOLD, bold);
        this.notifyNodePropertiesChanged();
    }

    public boolean isItalic() {
        return this.getStyle().getBooleanStyleProperty(TextStyleKeys.ITALIC);
    }

    public void setItalic(boolean italic) {
        this.getStyle().setBooleanStyleProperty(TextStyleKeys.ITALIC, italic);
        this.notifyNodePropertiesChanged();
    }

    public boolean isUnderline() {
        return this.getStyle().getBooleanStyleProperty(TextStyleKeys.UNDERLINED);
    }

    public void setUnderline(boolean underline) {
        this.getStyle().setBooleanStyleProperty(TextStyleKeys.UNDERLINED, underline);
        this.notifyNodePropertiesChanged();
    }

    public boolean isStrikethrough() {
        return this.getStyle().getBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH);
    }

    public void setStrikethrough(boolean strikethrough) {
        this.getStyle().setBooleanStyleProperty(TextStyleKeys.STRIKETHROUGH, strikethrough);
        this.notifyNodePropertiesChanged();
    }

    public FontDefinition getFont() {
        return this.getStyle().getFontDefinitionProperty();
    }

    public void setFont(FontDefinition font) {
        this.getStyle().setFontDefinitionProperty(font);
        this.notifyNodePropertiesChanged();
    }

    public float getLineHeight() {
        Float i = (Float)this.getStyle().getStyleProperty(TextStyleKeys.LINEHEIGHT);
        if (i == null) {
            return 0.0f;
        }
        return i.floatValue();
    }

    public void setLineHeight(float lineHeight) {
        this.getStyle().setStyleProperty(TextStyleKeys.LINEHEIGHT, new Float(lineHeight));
        this.notifyNodePropertiesChanged();
    }

    public String getReservedLiteral() {
        return (String)this.getStyle().getStyleProperty(TextStyleKeys.RESERVED_LITERAL);
    }

    public void setReservedLiteral(String reservedLiteral) {
        this.getStyle().setStyleProperty(TextStyleKeys.RESERVED_LITERAL, reservedLiteral);
        this.notifyNodePropertiesChanged();
    }
}

