/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.WatermarkType;
import org.pentaho.reporting.engine.classic.core.style.BandDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class Watermark
extends Band
implements RootLevelBand {
    private static final SubReport[] EMPTY_SUB_REPORT = new SubReport[0];
    private static ElementDefaultStyleSheet defaultStyle;

    public static synchronized ElementDefaultStyleSheet getDefaultStyle() {
        if (defaultStyle == null) {
            defaultStyle = new WatermarkDefaultStyleSheet();
        }
        return defaultStyle;
    }

    public Watermark() {
        this.setElementType(new WatermarkType());
    }

    protected ElementDefaultStyleSheet createGlobalDefaultStyle() {
        return Watermark.getDefaultStyle();
    }

    public Watermark(boolean onFirstPage, boolean onLastPage) {
        if (!onFirstPage) {
            this.setDisplayOnFirstPage(onFirstPage);
        }
        if (!onLastPage) {
            this.setDisplayOnLastPage(onLastPage);
        }
    }

    public boolean isDisplayOnFirstPage() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE);
    }

    public void setDisplayOnFirstPage(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE, b);
        this.notifyNodePropertiesChanged();
    }

    public boolean isDisplayOnLastPage() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE);
    }

    public void setDisplayOnLastPage(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE, b);
        this.notifyNodePropertiesChanged();
    }

    public int getSubReportCount() {
        return 0;
    }

    public SubReport getSubReport(int index) {
        throw new IndexOutOfBoundsException("Watermark bands cannot have subreports.");
    }

    public SubReport[] getSubReports() {
        return EMPTY_SUB_REPORT;
    }

    public boolean isSticky() {
        return this.getStyle().getBooleanStyleProperty(BandStyleKeys.STICKY, false);
    }

    public void setSticky(boolean b) {
        this.getStyle().setBooleanStyleProperty(BandStyleKeys.STICKY, b);
        this.notifyNodePropertiesChanged();
    }

    private static class WatermarkDefaultStyleSheet
    extends BandDefaultStyleSheet {
        protected WatermarkDefaultStyleSheet() {
            this.setLocked(false);
            this.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, new Float(-100.0f));
            this.setLocked(true);
        }
    }
}

