/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import java.util.HashMap;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactorySupport;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.cache.DataCache;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheFactory;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheKey;
import org.pentaho.reporting.engine.classic.core.cache.IndexedMetaTableModel;
import org.pentaho.reporting.engine.classic.core.cache.IndexedTableModel;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class CachingDataFactory
implements DataFactory,
CompoundDataFactorySupport {
    private static final Log logger = LogFactory.getLog(CachingDataFactory.class);
    private static final Object NULL_INDICATOR = new Object();
    private DataCache dataCache;
    private HashMap<String, HashMap<StaticDataRow, Object>> queryCache;
    private CompoundDataFactory backend;
    private boolean closed;
    private boolean debugDataSources;
    private boolean profileDataSources;
    private boolean noClose;
    private static final String[] EMPTY_NAMES = new String[0];

    public CachingDataFactory(DataFactory backend, boolean dataCacheEnabled) {
        this(backend, false, dataCacheEnabled);
    }

    public CachingDataFactory(DataFactory backend, boolean noClose, boolean dataCacheEnabled) {
        if (backend == null) {
            throw new NullPointerException();
        }
        this.noClose = noClose;
        this.backend = noClose ? CompoundDataFactory.normalize(backend, false) : CompoundDataFactory.normalize(backend, true);
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.queryCache = new HashMap();
        this.dataCache = dataCacheEnabled ? DataCacheFactory.getCache() : null;
        this.debugDataSources = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.DebugDataSources"));
        this.profileDataSources = "true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.ProfileDataSources"));
    }

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) throws ReportDataFactoryException {
        this.backend.initialize(configuration, resourceManager, contextKey, resourceBundleFactory);
    }

    public void open() throws ReportDataFactoryException {
        if (!this.noClose) {
            this.backend.open();
        }
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        return this.backend.isQueryExecutable(query, parameters);
    }

    public boolean isFreeFormQueryExecutable(String query, DataRow parameter) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameter == null) {
            throw new NullPointerException();
        }
        return this.backend.isFreeFormQueryExecutable(query, parameter);
    }

    public TableModel queryStatic(String query, DataRow parameters) throws ReportDataFactoryException {
        TableModel model;
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        DataCacheKey key = this.createCacheKey(query, parameters);
        if (key != null && (model = this.dataCache.get(key)) != null) {
            if (model instanceof MetaTableModel) {
                return new IndexedMetaTableModel((MetaTableModel)model);
            }
            return new IndexedTableModel(model);
        }
        if (!this.backend.isStaticQueryExecutable(query, parameters)) {
            throw new ReportDataFactoryException("The specified query '" + query + "' is not executable here.");
        }
        TableModel data = this.queryInternal(query, parameters, QueryStyle.Static);
        if (data == null) {
            return null;
        }
        if (key != null) {
            TableModel newData = this.dataCache.put(key, data);
            if (newData != data && data instanceof CloseableTableModel) {
                CloseableTableModel closeableTableModel = (CloseableTableModel)data;
                closeableTableModel.close();
            }
            data = newData;
        }
        if (data instanceof MetaTableModel) {
            return new IndexedMetaTableModel((MetaTableModel)data);
        }
        return new IndexedTableModel(data);
    }

    public TableModel queryFreeForm(String query, DataRow parameters) throws ReportDataFactoryException {
        TableModel model;
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        DataCacheKey key = this.createCacheKey(query, parameters);
        if (key != null && (model = this.dataCache.get(key)) != null) {
            if (model instanceof MetaTableModel) {
                return new IndexedMetaTableModel((MetaTableModel)model);
            }
            return new IndexedTableModel(model);
        }
        if (!this.backend.isFreeFormQueryExecutable(query, parameters)) {
            throw new ReportDataFactoryException("The specified query '" + query + "' is not executable here.");
        }
        TableModel data = this.queryInternal(query, parameters, QueryStyle.FreeForm);
        if (data == null) {
            return null;
        }
        if (key != null) {
            TableModel newData = this.dataCache.put(key, data);
            if (newData != data && data instanceof CloseableTableModel) {
                CloseableTableModel closeableTableModel = (CloseableTableModel)data;
                closeableTableModel.close();
            }
            data = newData;
        }
        if (data instanceof MetaTableModel) {
            return new IndexedMetaTableModel((MetaTableModel)data);
        }
        return new IndexedTableModel(data);
    }

    public boolean isStaticQueryExecutable(String query, DataRow parameters) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        return this.backend.isStaticQueryExecutable(query, parameters);
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        TableModel data;
        TableModel model;
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        DataCacheKey key = this.createCacheKey(query, parameters);
        if (key != null && (model = this.dataCache.get(key)) != null) {
            if (model instanceof MetaTableModel) {
                return new IndexedMetaTableModel((MetaTableModel)model);
            }
            return new IndexedTableModel(model);
        }
        if (this.backend.isQueryExecutable(query, parameters) && (data = this.queryInternal(query, parameters, QueryStyle.General)) != null) {
            if (key != null) {
                TableModel newData = this.dataCache.put(key, data);
                if (newData != data && data instanceof CloseableTableModel) {
                    CloseableTableModel closeableTableModel = (CloseableTableModel)data;
                    closeableTableModel.close();
                }
                data = newData;
            }
            if (data instanceof MetaTableModel) {
                return new IndexedMetaTableModel((MetaTableModel)data);
            }
            return new IndexedTableModel(data);
        }
        throw new ReportDataFactoryException("The specified query '" + query + "' is not executable here.");
    }

    private DataCacheKey createCacheKey(String query, DataRow parameters) {
        try {
            DataCacheKey key;
            DataFactory dataFactoryForQuery = this.backend.getDataFactoryForQuery(query);
            if (dataFactoryForQuery != null && this.dataCache != null) {
                String metaKey = dataFactoryForQuery.getClass().getName();
                DataFactoryMetaData metaData = DataFactoryRegistry.getInstance().getMetaData(metaKey);
                String[] referencedFields = metaData.getReferencedFields(dataFactoryForQuery, query, parameters);
                if (referencedFields != null) {
                    Object queryHash = metaData.getQueryHash(dataFactoryForQuery, query, parameters);
                    if (queryHash == null) {
                        key = null;
                    } else {
                        key = new DataCacheKey();
                        for (int i = 0; i < referencedFields.length; ++i) {
                            String field = referencedFields[i];
                            key.addParameter(field, parameters.get(field));
                        }
                        key.addAttribute("QueryCache", queryHash);
                    }
                } else {
                    key = null;
                }
            } else {
                key = null;
            }
            return key;
        }
        catch (MetaDataLookupException mle) {
            logger.error((Object)("Data-source used for query '" + query + "' does not provide metadata. Caching will be disabled."), (Throwable)((Object)mle));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableModel queryInternal(String query, DataRow parameters, QueryStyle queryStyle) throws ReportDataFactoryException {
        if (this.profileDataSources && logger.isDebugEnabled()) {
            logger.debug((Object)(System.identityHashCode(Thread.currentThread()) + ": Query processing time: Starting"));
        }
        long startTime = System.currentTimeMillis();
        try {
            TableModel newData;
            HashMap<StaticDataRow, Object> parameterCache = this.queryCache.get(query);
            if (parameterCache == null) {
                TableModel dataFromQuery;
                StaticDataRow params = new StaticDataRow(parameters);
                switch (queryStyle) {
                    case FreeForm: {
                        dataFromQuery = this.backend.queryFreeForm(query, params);
                        break;
                    }
                    case Static: {
                        dataFromQuery = this.backend.queryStatic(query, params);
                        break;
                    }
                    case General: {
                        dataFromQuery = this.backend.queryData(query, params);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (dataFromQuery == null) {
                    if (this.debugDataSources && logger.isDebugEnabled()) {
                        logger.debug((Object)("Query failed for query '" + query + '\''));
                    }
                    HashMap<StaticDataRow, Object> paramsForQueryMap = new HashMap<StaticDataRow, Object>();
                    this.queryCache.put(query, paramsForQueryMap);
                    paramsForQueryMap.put(params, NULL_INDICATOR);
                    TableModel tableModel = null;
                    return tableModel;
                }
                if (this.debugDataSources && logger.isDebugEnabled()) {
                    CachingDataFactory.printTableModelContents(dataFromQuery);
                }
                HashMap<StaticDataRow, TableModel> paramsForQueryMap = new HashMap<StaticDataRow, TableModel>();
                this.queryCache.put(query, paramsForQueryMap);
                paramsForQueryMap.put(params, dataFromQuery);
                TableModel tableModel = dataFromQuery;
                return tableModel;
            }
            StaticDataRow params = new StaticDataRow(parameters);
            Object dataObj = parameterCache.get(params);
            if (dataObj == NULL_INDICATOR) {
                TableModel paramsForQueryMap = null;
                return paramsForQueryMap;
            }
            TableModel data = (TableModel)dataObj;
            if (data != null) {
                TableModel queryTime = data;
                return queryTime;
            }
            switch (queryStyle) {
                case FreeForm: {
                    newData = this.backend.queryFreeForm(query, params);
                    break;
                }
                case Static: {
                    newData = this.backend.queryStatic(query, params);
                    break;
                }
                case General: {
                    newData = this.backend.queryData(query, params);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (newData == null) {
                if (this.debugDataSources && logger.isDebugEnabled()) {
                    logger.debug((Object)("Query failed for query '" + query + '\''));
                }
                parameterCache.put(params, NULL_INDICATOR);
                TableModel tableModel = null;
                return tableModel;
            }
            if (this.debugDataSources && logger.isDebugEnabled()) {
                CachingDataFactory.printTableModelContents(newData);
            }
            parameterCache.put(params, newData);
            TableModel tableModel = newData;
            return tableModel;
        }
        finally {
            long queryTime = System.currentTimeMillis();
            if (this.profileDataSources && logger.isDebugEnabled()) {
                logger.debug((Object)(System.identityHashCode(Thread.currentThread()) + ": Query processing time: " + (double)(queryTime - startTime) / 1000.0));
            }
        }
    }

    public void close() {
        if (!this.closed) {
            for (HashMap<StaticDataRow, Object> map : this.queryCache.values()) {
                for (Object o : map.values()) {
                    if (!(o instanceof CloseableTableModel)) continue;
                    CloseableTableModel ct = (CloseableTableModel)o;
                    ct.close();
                }
            }
            this.queryCache.clear();
            if (!this.noClose) {
                this.backend.close();
            }
            this.closed = true;
        }
    }

    public DataFactory derive() {
        throw new UnsupportedOperationException("The CachingReportDataFactory cannot be derived.");
    }

    public static void printTableModelContents(TableModel mod) {
        if (mod == null) {
            throw new NullPointerException();
        }
        logger.debug((Object)("Tablemodel contains " + mod.getRowCount() + " rows."));
        for (int i = 0; i < mod.getColumnCount(); ++i) {
            logger.debug((Object)("Column: " + i + " Name = " + mod.getColumnName(i) + "; DataType = " + mod.getColumnClass(i)));
        }
        logger.debug((Object)"Checking the data inside");
        for (int rows = 0; rows < mod.getRowCount(); ++rows) {
            for (int i = 0; i < mod.getColumnCount(); ++i) {
                Object value = mod.getValueAt(rows, i);
                logger.debug((Object)("ValueAt (" + rows + ", " + i + ") is " + value));
            }
        }
    }

    public String[] getQueryNames() {
        return EMPTY_NAMES;
    }

    public void cancelRunningQuery() {
    }

    public Object clone() {
        try {
            CachingDataFactory cdf = (CachingDataFactory)super.clone();
            cdf.backend = (CompoundDataFactory)this.backend.clone();
            cdf.queryCache = (HashMap)this.queryCache.clone();
            return cdf;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public DataFactory getDataFactoryForQuery(String queryName, boolean freeform) {
        return this.backend.getDataFactoryForQuery(queryName, freeform);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum QueryStyle {
        General,
        Static,
        FreeForm;

    }
}

