/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import javax.swing.table.TableModel;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.cache.CachableTableModel;
import org.pentaho.reporting.engine.classic.core.cache.DataCache;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheKey;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheManager;

public class EhCacheDataCache
implements DataCache {
    private static final String CACHE_NAME = "report-dataset-cache";
    private DataCacheManager cacheManager;
    private int maximumRows;
    private CacheManager manager;
    private Cache cache;

    public EhCacheDataCache() {
        this(ClassicEngineBoot.getInstance().getExtendedConfig().getIntProperty("org.pentaho.reporting.engine.classic.core.cache.EhCacheDataCache.CachableRowLimit"));
    }

    public EhCacheDataCache(int maximumRows) {
        this.maximumRows = maximumRows;
        this.manager = ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.engine.classic.core.cache.EhCacheDataCache.UseGlobalCacheManager") ? CacheManager.getInstance() : new CacheManager();
        this.cacheManager = new GlobalCacheManager();
        if (!this.manager.cacheExists(CACHE_NAME)) {
            this.manager.addCache(CACHE_NAME);
        }
        this.cache = this.manager.getCache(CACHE_NAME);
    }

    public int getMaximumRows() {
        return this.maximumRows;
    }

    public TableModel get(DataCacheKey key) {
        Element element = this.cache.get((Object)key);
        if (element == null) {
            return null;
        }
        return (TableModel)element.getObjectValue();
    }

    public TableModel put(DataCacheKey key, TableModel model) {
        if (model.getRowCount() > this.maximumRows) {
            return model;
        }
        if (!CachableTableModel.isSafeToCache(model)) {
            return model;
        }
        CachableTableModel cacheModel = new CachableTableModel(model);
        this.cache.put(new Element((Object)key, (Object)cacheModel));
        return cacheModel;
    }

    public DataCacheManager getCacheManager() {
        return this.cacheManager;
    }

    private class GlobalCacheManager
    implements DataCacheManager {
        private GlobalCacheManager() {
        }

        public void clearAll() {
            EhCacheDataCache.this.cache.removeAll();
        }

        public void shutdown() {
            EhCacheDataCache.this.cache.removeAll();
            if (ClassicEngineBoot.getInstance().getExtendedConfig().getBoolProperty("org.pentaho.reporting.engine.classic.core.cache.EhCacheDataCache.UseGlobalCacheManager")) {
                EhCacheDataCache.this.manager.shutdown();
            }
        }
    }
}

