/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.cache;

import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.cache.CachableTableModel;
import org.pentaho.reporting.engine.classic.core.cache.DataCache;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheKey;
import org.pentaho.reporting.engine.classic.core.cache.DataCacheManager;
import org.pentaho.reporting.libraries.base.util.LFUMap;

public class InMemoryDataCache
implements DataCache {
    private InMemoryCacheManager cacheManager;
    private LFUMap<DataCacheKey, TableModel> dataCache;
    private int maximumEntries;
    private int maximumRows;

    public InMemoryDataCache() {
        this(ClassicEngineBoot.getInstance().getExtendedConfig().getIntProperty("org.pentaho.reporting.engine.classic.core.cache.InMemoryCache.MaxEntries"), ClassicEngineBoot.getInstance().getExtendedConfig().getIntProperty("org.pentaho.reporting.engine.classic.core.cache.InMemoryCache.CachableRowLimit"));
    }

    public InMemoryDataCache(int maximumEntries, int maximumRows) {
        this.maximumEntries = maximumEntries;
        this.maximumRows = maximumRows;
        this.cacheManager = new InMemoryCacheManager();
        this.dataCache = new LFUMap(maximumEntries);
    }

    public int getMaximumEntries() {
        return this.maximumEntries;
    }

    public int getMaximumRows() {
        return this.maximumRows;
    }

    public TableModel get(DataCacheKey key) {
        return (TableModel)this.dataCache.get((Object)key);
    }

    public TableModel put(DataCacheKey key, TableModel model) {
        if (model.getRowCount() > this.maximumRows) {
            return model;
        }
        if (!CachableTableModel.isSafeToCache(model)) {
            return model;
        }
        CachableTableModel cacheModel = new CachableTableModel(model);
        this.dataCache.put((Object)key, (Object)cacheModel);
        return cacheModel;
    }

    public DataCacheManager getCacheManager() {
        return this.cacheManager;
    }

    private class InMemoryCacheManager
    implements DataCacheManager {
        private InMemoryCacheManager() {
        }

        public void clearAll() {
            InMemoryDataCache.this.dataCache.clear();
        }

        public void shutdown() {
            InMemoryDataCache.this.dataCache.clear();
        }
    }
}

