/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime;

import java.util.Date;
import java.util.HashMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.cache.CachingDataFactory;
import org.pentaho.reporting.engine.classic.core.cache.IndexedTableModel;
import org.pentaho.reporting.engine.classic.core.designtime.OfflineTableModel;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.states.QueryDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.states.datarow.EmptyTableModel;
import org.pentaho.reporting.engine.classic.core.states.datarow.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaCompiler;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataSchema;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.LinkedMap;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class DesignTimeDataSchemaModel
implements DataSchemaModel {
    private AbstractReportDefinition parent;
    private DataSchema dataSchema;
    private DataSchemaDefinition dataSchemaDefinition;
    private DataAttributeContext dataAttributeContext;
    private MasterReport masterReportElement;
    private String[] columnNames;
    private static final String[] EMPTY_NAMES = new String[0];
    private String query;
    private int oldQueryTimeout;
    private OfflineTableModel offlineTableModel;
    private Throwable dataFactoryException;
    private HashMap<InstanceID, Long> nonVisualChangeTrackers;
    private HashMap<InstanceID, Long> dataFactoryChangeTrackers;

    public DesignTimeDataSchemaModel(AbstractReportDefinition report) {
        this(DesignTimeDataSchemaModel.locateMasterReport(report), report);
    }

    private static MasterReport locateMasterReport(AbstractReportDefinition reportDefinition) {
        if (reportDefinition == null) {
            return null;
        }
        if (reportDefinition instanceof MasterReport) {
            return (MasterReport)reportDefinition;
        }
        for (Section parent = reportDefinition.getParentSection(); parent != null; parent = parent.getParentSection()) {
            if (!(parent instanceof MasterReport)) continue;
            return (MasterReport)parent;
        }
        return null;
    }

    public DesignTimeDataSchemaModel(MasterReport masterReportElement, AbstractReportDefinition report) {
        if (masterReportElement == null) {
            throw new NullPointerException();
        }
        if (report == null) {
            throw new NullPointerException();
        }
        this.columnNames = EMPTY_NAMES;
        this.query = report.getQuery();
        this.masterReportElement = masterReportElement;
        this.parent = report;
        this.nonVisualChangeTrackers = new HashMap();
        this.dataFactoryChangeTrackers = new HashMap();
        this.dataSchemaDefinition = masterReportElement.getDataSchemaDefinition();
        if (this.dataSchemaDefinition == null) {
            this.dataSchemaDefinition = DataSchemaUtility.parseDefaults(masterReportElement.getResourceManager());
        }
        this.dataAttributeContext = new DefaultDataAttributeContext();
    }

    public DataAttributeContext getDataAttributeContext() {
        return this.dataAttributeContext;
    }

    public AbstractReportDefinition getParent() {
        return this.parent;
    }

    public boolean isValid() {
        this.ensureDataSchemaValid();
        return this.dataFactoryException == null;
    }

    public DataSchema getDataSchema() {
        this.ensureDataSchemaValid();
        return this.dataSchema;
    }

    private boolean isNonVisualsChanged() {
        AbstractReportDefinition parent = this.parent;
        while (parent != null) {
            InstanceID id = parent.getObjectID();
            Long dataSourceChangeTracker = parent.getDatasourceChangeTracker();
            if (!dataSourceChangeTracker.equals(this.dataFactoryChangeTrackers.get(id))) {
                return true;
            }
            Long nonVisualsChangeTracker = parent.getNonVisualsChangeTracker();
            if (!nonVisualsChangeTracker.equals(this.nonVisualChangeTrackers.get(id))) {
                return true;
            }
            Section parentSection = parent.getParentSection();
            if (parentSection == null) {
                parent = null;
                continue;
            }
            parent = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return false;
    }

    private boolean isDataFactoryChanged() {
        AbstractReportDefinition parent = this.parent;
        while (parent != null) {
            InstanceID id = parent.getObjectID();
            Long dataSourceChangeTracker = parent.getDatasourceChangeTracker();
            if (!dataSourceChangeTracker.equals(this.dataFactoryChangeTrackers.get(id))) {
                return true;
            }
            Section parentSection = parent.getParentSection();
            if (parentSection == null) {
                parent = null;
                continue;
            }
            parent = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return false;
    }

    private void updateChangeTrackers() {
        AbstractReportDefinition parent = this.parent;
        while (parent != null) {
            InstanceID id = parent.getObjectID();
            this.dataFactoryChangeTrackers.put(id, parent.getDatasourceChangeTracker());
            this.nonVisualChangeTrackers.put(id, parent.getNonVisualsChangeTracker());
            Section parentSection = parent.getParentSection();
            if (parentSection == null) {
                parent = null;
                continue;
            }
            parent = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
    }

    private void ensureDataSchemaValid() {
        if (this.dataSchema == null || this.isNonVisualsChanged() || !ObjectUtilities.equal((Object)this.query, (Object)this.parent.getQuery())) {
            try {
                this.dataFactoryException = null;
                this.dataSchema = this.buildDataSchema();
            }
            catch (Throwable e) {
                this.handleError(e);
                this.dataSchema = new DefaultDataSchema();
                this.dataFactoryException = e;
                this.query = this.parent.getQuery();
            }
            this.updateChangeTrackers();
        }
    }

    protected void handleError(Throwable e) {
        DebugLog.log((Object)"Failure", (Throwable)e);
    }

    public Throwable getDataFactoryException() {
        return this.dataFactoryException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSchema buildDataSchema() throws ReportDataFactoryException {
        ParameterDataRow parameterRow;
        ParameterDefinitionEntry[] parameterDefinitions;
        this.columnNames = EMPTY_NAMES;
        this.dataFactoryException = null;
        if (this.parent instanceof MasterReport) {
            MasterReport mr = (MasterReport)this.parent;
            parameterDefinitions = mr.getParameterDefinition().getParameterDefinitions();
            LinkedMap values = DesignTimeDataSchemaModel.computeParameterValueSet(mr);
            parameterRow = new ParameterDataRow((String[])values.keys((Object[])new String[values.size()]), values.values());
        } else if (this.parent instanceof SubReport) {
            SubReport sr = (SubReport)this.parent;
            ParameterMapping[] inputMappings = sr.getInputMappings();
            Object[] values = new Object[inputMappings.length];
            String[] names = new String[inputMappings.length];
            parameterDefinitions = null;
            for (int i = 0; i < inputMappings.length; ++i) {
                ParameterMapping inputMapping = inputMappings[i];
                names[i] = inputMapping.getAlias();
            }
            parameterRow = new ParameterDataRow(names, values);
        } else {
            parameterDefinitions = null;
            parameterRow = new ParameterDataRow();
        }
        Expression[] expressions = this.parent.getExpressions().getExpressions();
        DataSchemaCompiler dataSchemaCompiler = new DataSchemaCompiler(this.dataSchemaDefinition, this.dataAttributeContext, this.masterReportElement.getResourceManager());
        CachingDataFactory dataFactory = new CachingDataFactory(this.createDataFactory(this.parent), true);
        MasterReport masterReport = this.masterReportElement;
        dataFactory.initialize(masterReport.getConfiguration(), masterReport.getResourceManager(), masterReport.getContentBase(), MasterReport.computeAndInitResourceBundleFactory(masterReport.getResourceBundleFactory(), masterReport.getReportEnvironment()));
        dataFactory.open();
        try {
            TableModel reportData = this.queryReportData(this.parent.getQuery(), this.parent.getQueryTimeout(), dataFactory);
            DataSchema dataSchema = dataSchemaCompiler.compile(reportData, expressions, parameterRow, parameterDefinitions, masterReport.getReportEnvironment());
            this.columnNames = this.collectColumnNames(reportData, parameterRow, expressions);
            if (reportData instanceof CloseableTableModel) {
                CloseableTableModel ctm = (CloseableTableModel)reportData;
                ctm.close();
            }
            DataSchema dataSchema2 = dataSchema;
            dataFactory.close();
            return dataSchema2;
        }
        catch (Throwable throwable) {
            try {
                dataFactory.close();
                throw throwable;
            }
            catch (ReportProcessingException e) {
                DefaultTableModel reportData = new DefaultTableModel();
                DataSchema dataSchema = dataSchemaCompiler.compile(reportData, expressions, parameterRow, parameterDefinitions, this.masterReportElement.getReportEnvironment());
                this.columnNames = this.collectColumnNames(reportData, parameterRow, expressions);
                this.dataFactoryException = e;
                return dataSchema;
            }
        }
    }

    private CompoundDataFactory createDataFactory(AbstractReportDefinition reportDefinition) throws ReportDataFactoryException {
        CompoundDataFactory cdf = new CompoundDataFactory();
        while (reportDefinition != null) {
            Section parentSection;
            DataFactory dataFactory = reportDefinition.getDataFactory();
            if (dataFactory != null) {
                cdf.add(dataFactory);
            }
            if ((parentSection = reportDefinition.getParentSection()) == null) {
                reportDefinition = null;
                continue;
            }
            reportDefinition = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return CompoundDataFactory.normalize(cdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableModel queryReportData(String query, int queryTimeout, DataFactory dataFactory) throws ReportDataFactoryException {
        if (!ObjectUtilities.equal((Object)this.query, (Object)query) || queryTimeout != this.oldQueryTimeout || this.isDataFactoryChanged()) {
            TableModel reportData = null;
            try {
                reportData = query == null ? new EmptyTableModel() : dataFactory.queryData(query, new QueryDataRowWrapper((DataRow)new StaticDataRow(), 1, queryTimeout));
                this.query = query;
                this.oldQueryTimeout = queryTimeout;
                this.offlineTableModel = new OfflineTableModel(reportData, new DefaultDataAttributeContext());
            }
            finally {
                if (reportData instanceof CloseableTableModel) {
                    CloseableTableModel ctm = (CloseableTableModel)reportData;
                    ctm.close();
                }
            }
        }
        if (this.offlineTableModel == null) {
            return new IndexedTableModel(new DefaultTableModel());
        }
        return this.offlineTableModel;
    }

    private String[] collectColumnNames(TableModel reportData, ParameterDataRow parameterRow, Expression[] expressions) {
        int i;
        LinkedMap columnNamesCollector = new LinkedMap();
        LinkedMap envCols = ReportEnvironmentDataRow.createEnvironmentMapping();
        Object[] envColArray = envCols.values();
        for (int i2 = 0; i2 < envColArray.length; ++i2) {
            String name = (String)envColArray[i2];
            columnNamesCollector.put((Object)name, (Object)Boolean.TRUE);
        }
        String[] strings = parameterRow.getColumnNames();
        for (int i3 = 0; i3 < strings.length; ++i3) {
            String string = strings[i3];
            columnNamesCollector.put((Object)string, (Object)Boolean.TRUE);
        }
        int count = reportData.getColumnCount();
        for (i = 0; i < count; ++i) {
            columnNamesCollector.put((Object)reportData.getColumnName(i), (Object)Boolean.TRUE);
        }
        for (i = 0; i < expressions.length; ++i) {
            Expression expression = expressions[i];
            String name = expression.getName();
            if (name == null) continue;
            columnNamesCollector.put((Object)name, (Object)Boolean.TRUE);
        }
        return (String[])columnNamesCollector.keys((Object[])new String[columnNamesCollector.size()]);
    }

    public String[] getColumnNames() {
        this.ensureDataSchemaValid();
        return (String[])this.columnNames.clone();
    }

    public boolean isSelectedDataSource(DataFactory dataFactory, String queryName) {
        this.ensureDataSchemaValid();
        if (!ObjectUtilities.equal((Object)queryName, (Object)this.query)) {
            return false;
        }
        AbstractReportDefinition reportDefinition = this.getParent();
        while (reportDefinition != null) {
            Section parentSection;
            DataFactory reportDataFactory = reportDefinition.getDataFactory();
            if (reportDataFactory instanceof CompoundDataFactory) {
                CompoundDataFactory compoundDataFactory = (CompoundDataFactory)reportDataFactory;
                for (int i = 0; i < compoundDataFactory.size(); ++i) {
                    DataFactory df = compoundDataFactory.getReference(i);
                    for (String query : df.getQueryNames()) {
                        if (!query.equals(queryName)) continue;
                        return df == dataFactory;
                    }
                }
            } else if (reportDataFactory != null) {
                for (String query : reportDataFactory.getQueryNames()) {
                    if (!query.equals(queryName)) continue;
                    return reportDataFactory == dataFactory;
                }
                return true;
            }
            if ((parentSection = reportDefinition.getParentSection()) == null) {
                reportDefinition = null;
                continue;
            }
            reportDefinition = (AbstractReportDefinition)parentSection.getReportDefinition();
        }
        return false;
    }

    public static LinkedMap computeParameterValueSet(MasterReport report) {
        LinkedMap retval = new LinkedMap();
        retval.put((Object)"report.date", (Object)new Date());
        String reportName = (String)report.getProperty("report.name");
        if (!StringUtils.isEmpty((String)reportName)) {
            retval.put((Object)"report.name", (Object)reportName);
        }
        ReportParameterValues reportParameterValues = report.getParameterValues();
        ParameterDefinitionEntry[] columnNames = report.getParameterDefinition().getParameterDefinitions();
        for (int i = 0; i < columnNames.length; ++i) {
            ParameterDefinitionEntry parameter = columnNames[i];
            String columnName = parameter.getName();
            if (columnName == null) continue;
            retval.put((Object)columnName, reportParameterValues.get(columnName));
        }
        return retval;
    }
}

