/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.DataRowDataSource;
import org.pentaho.reporting.engine.classic.core.filter.DateFormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.types.DateFieldType;
import org.pentaho.reporting.engine.classic.core.filter.types.LegacyType;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;

public class DateFieldElementFactory
extends TextFieldElementFactory {
    private DateFormat format;
    private String excelCellFormat;

    public String getExcelCellFormat() {
        return this.excelCellFormat;
    }

    public void setExcelCellFormat(String excelCellFormat) {
        this.excelCellFormat = excelCellFormat;
    }

    public DateFormat getFormat() {
        return this.format;
    }

    public void setFormat(DateFormat format) {
        this.format = format;
    }

    public String getFormatString() {
        if (this.getFormat() instanceof SimpleDateFormat) {
            SimpleDateFormat decFormat = (SimpleDateFormat)this.getFormat();
            return decFormat.toPattern();
        }
        return null;
    }

    public void setFormatString(String formatString) {
        if (formatString == null) {
            this.setFormat(null);
        } else {
            this.setFormat(new SimpleDateFormat(formatString));
        }
    }

    public Element createElement() {
        Element element = new Element();
        if (this.format instanceof SimpleDateFormat || this.format == null) {
            element.setElementType(new DateFieldType());
            if (this.getFieldname() != null) {
                element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field", this.getFieldname());
            }
            if (this.getFormula() != null) {
                FormulaExpression formulaExpression = new FormulaExpression();
                formulaExpression.setFormula(this.getFormula());
                element.setAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", formulaExpression);
            }
            if (this.format != null) {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.format;
                String formatString = simpleDateFormat.toPattern();
                element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", formatString);
            }
            element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", this.getNullString());
        } else {
            element.setElementType(new LegacyType());
            DateFormatFilter dataSource = new DateFormatFilter();
            if (this.format != null) {
                dataSource.setFormatter(this.format);
            }
            DataRowDataSource dds = new DataRowDataSource();
            if (this.getFormula() != null) {
                dds.setFormula(this.getFormula());
            } else {
                dds.setDataSourceColumnName(this.getFieldname());
            }
            dataSource.setDataSource(dds);
            if (this.getNullString() != null) {
                dataSource.setNullValue(this.getNullString());
            }
            element.setDataSource(dataSource);
        }
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.getStyle().setStyleProperty(ElementStyleKeys.EXCEL_DATA_FORMAT_STRING, this.getExcelCellFormat());
        return element;
    }

    public static Element createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, String format, String field) {
        return DateFieldElementFactory.createDateElement(name, bounds, paint, alignment, null, font, nullString, format, field);
    }

    public static Element createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, String format, String field) {
        DateFieldElementFactory factory = new DateFieldElementFactory();
        factory.setX(new Float(bounds.getX()));
        factory.setY(new Float(bounds.getY()));
        factory.setMinimumWidth(new Float(bounds.getWidth()));
        factory.setMinimumHeight(new Float(bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(ElementFactory.getBooleanValue(font.isBold()));
            factory.setItalic(ElementFactory.getBooleanValue(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(font.getFontEncoding(null)));
            factory.setUnderline(ElementFactory.getBooleanValue(font.isUnderline()));
            factory.setStrikethrough(ElementFactory.getBooleanValue(font.isStrikeThrough()));
            factory.setEmbedFont(ElementFactory.getBooleanValue(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormatString(format);
        factory.setFieldname(field);
        return factory.createElement();
    }

    public static Element createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, DateFormat format, String field) {
        return DateFieldElementFactory.createDateElement(name, bounds, paint, alignment, null, font, nullString, format, field);
    }

    public static Element createDateElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, DateFormat format, String field) {
        DateFieldElementFactory factory = new DateFieldElementFactory();
        factory.setX(new Float(bounds.getX()));
        factory.setY(new Float(bounds.getY()));
        factory.setMinimumWidth(new Float(bounds.getWidth()));
        factory.setMinimumHeight(new Float(bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(ElementFactory.getBooleanValue(font.isBold()));
            factory.setItalic(ElementFactory.getBooleanValue(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(font.getFontEncoding(null)));
            factory.setUnderline(ElementFactory.getBooleanValue(font.isUnderline()));
            factory.setStrikethrough(ElementFactory.getBooleanValue(font.isStrikeThrough()));
            factory.setEmbedFont(ElementFactory.getBooleanValue(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormat(format);
        factory.setFieldname(field);
        return factory.createElement();
    }
}

