/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.awt.Color;
import java.awt.Stroke;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.elementfactory.AbstractContentElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.HorizontalLineType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class HorizontalLineElementFactory
extends AbstractContentElementFactory {
    public Element createElement() {
        Element element = new Element();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setElementType(new HorizontalLineType());
        return element;
    }

    public static Element createHorizontalLine(float y) {
        HorizontalLineElementFactory ef = new HorizontalLineElementFactory();
        ef.setX(new Float(0.0f));
        ef.setMinimumWidth(new Float(-100.0f));
        ef.setY(new Float(y));
        ef.setMinimumHeight(new Float(0.0f));
        ef.setShouldDraw(Boolean.TRUE);
        ef.setScale(Boolean.TRUE);
        return ef.createElement();
    }

    public static Element createHorizontalLine(float y, Color color, Stroke stroke) {
        Element element = HorizontalLineElementFactory.createHorizontalLine(y);
        element.getStyle().setStyleProperty(ElementStyleKeys.PAINT, color);
        element.getStyle().setStyleProperty(ElementStyleKeys.STROKE, stroke);
        return element;
    }
}

