/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.awt.Component;
import javax.swing.JFrame;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.util.ComponentDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class ComponentDrawableFilter
implements DataFilter {
    private DataSource source;
    private JFrame frame;

    public Object getValue(ExpressionRuntime runtime, Element element) {
        ComponentDrawable cd;
        if (ComponentDrawableFilter.isHeadless()) {
            return null;
        }
        if (runtime == null) {
            return null;
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue(runtime, element);
        if (o == null) {
            return null;
        }
        if (!(o instanceof Component)) {
            return null;
        }
        Configuration config = runtime.getConfiguration();
        String drawMode = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.ComponentDrawableMode", "shared");
        if ("private".equals(drawMode)) {
            cd = new ComponentDrawable();
        } else if ("synchronized".equals(drawMode)) {
            cd = new ComponentDrawable();
            cd.setPaintSynchronized(true);
        } else {
            if (this.frame == null) {
                this.frame = new JFrame();
            }
            cd = new ComponentDrawable(this.frame);
            cd.setPaintSynchronized(true);
        }
        String allowOwnPeer = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.AllowOwnPeerForComponentDrawable");
        cd.setAllowOwnPeer("true".equals(allowOwnPeer));
        cd.setComponent((Component)o);
        return cd;
    }

    protected static boolean isHeadless() {
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        return "true".equals(config.getConfigProperty("java.awt.headless", "false"));
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentDrawableFilter il = (ComponentDrawableFilter)super.clone();
        if (this.source != null) {
            il.source = (DataSource)this.source.clone();
        }
        return il;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public void setDataSource(DataSource ds) {
        this.source = ds;
    }
}

