/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;

public class DataRowDataSource
implements DataSource {
    private static final Log logger = LogFactory.getLog(DataRowDataSource.class);
    private String field;
    private FormulaExpression valueExpression;

    public DataRowDataSource() {
        this(null);
    }

    public DataRowDataSource(String column) {
        this.field = column;
    }

    public String getField() {
        return this.getDataSourceColumnName();
    }

    public void setField(String field) {
        this.setDataSourceColumnName(field);
    }

    public String getDataSourceColumnName() {
        return this.field;
    }

    public void setDataSourceColumnName(String dataSourceColumnName) {
        if (dataSourceColumnName == null) {
            throw new NullPointerException();
        }
        this.field = dataSourceColumnName;
        if (this.valueExpression != null) {
            this.valueExpression.setFormula(null);
        }
    }

    public String getFormula() {
        if (this.valueExpression == null) {
            return null;
        }
        return this.valueExpression.getFormula();
    }

    public void setFormula(String formula) {
        if (formula == null) {
            throw new NullPointerException();
        }
        this.field = null;
        if (this.valueExpression == null) {
            this.valueExpression = new FormulaExpression();
        }
        this.valueExpression.setFormula(formula);
        if ("field".equals(this.valueExpression.getFormulaNamespace())) {
            logger.warn((Object)"Encountered formula with 'field' prefix. Direct access to field-data should not be done using a formula. Auto-Fixing.");
            this.field = this.valueExpression.getFormulaExpression();
            this.valueExpression.setFormula(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            return null;
        }
        if (this.field != null) {
            return runtime.getDataRow().get(this.field);
        }
        if (this.valueExpression == null) {
            return null;
        }
        this.valueExpression.setRuntime(runtime);
        try {
            Object object = this.valueExpression.getValue();
            return object;
        }
        catch (Exception e) {
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.valueExpression.setRuntime(null);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataRowDataSource drs = (DataRowDataSource)super.clone();
        if (this.valueExpression != null) {
            drs.valueExpression = (FormulaExpression)this.valueExpression.clone();
        }
        return drs;
    }
}

