/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.NumberFormatParser;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DecimalFormatParser
extends NumberFormatParser {
    private Locale lastLocale;
    private boolean keepState;

    public DecimalFormatParser() {
        this.setFormatter(new DecimalFormat());
    }

    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.getFormatter();
    }

    public void setDecimalFormat(DecimalFormat format) {
        this.setFormatter(format);
    }

    public void setFormatter(Format format) {
        if (format == null) {
            throw new NullPointerException("The number format given must not be null.");
        }
        DecimalFormat dfmt = (DecimalFormat)format;
        this.activateBigDecimalMode(dfmt);
        super.setFormatter(dfmt);
    }

    private void activateBigDecimalMode(DecimalFormat format) {
        if (ObjectUtilities.isJDK14()) {
            try {
                Method method = DecimalFormat.class.getMethod("setParseBigDecimal", Boolean.TYPE);
                method.invoke((Object)format, Boolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getFormatString() {
        return this.getDecimalFormat().toPattern();
    }

    public void setFormatString(String format) {
        this.getDecimalFormat().applyPattern(format);
    }

    public String getLocalizedFormatString() {
        return this.getDecimalFormat().toLocalizedPattern();
    }

    public void setLocalizedFormatString(String format) {
        this.getDecimalFormat().applyLocalizedPattern(format);
    }

    public boolean isKeepState() {
        return this.keepState;
    }

    public void setKeepState(boolean keepState) {
        this.keepState = keepState;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Locale locale;
        if (!this.keepState && runtime != null && (locale = runtime.getResourceBundleFactory().getLocale()) != null && !locale.equals(this.lastLocale)) {
            this.lastLocale = locale;
            this.getDecimalFormat().setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
        }
        return super.getValue(runtime, element);
    }
}

