/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.sql.Blob;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class DrawableLoadFilter
implements DataFilter {
    private static final Log logger = LogFactory.getLog(DrawableLoadFilter.class);
    private transient HashSet failureCache = new HashSet();
    private DataSource source;

    public DrawableLoadFilter() {
    }

    public DrawableLoadFilter(int cacheSize) {
        this();
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue(runtime, element);
        if (o == null) {
            return null;
        }
        if (o instanceof URL) {
            URL url = (URL)o;
            String urlString = String.valueOf(url);
            if (this.failureCache.contains(urlString)) {
                return null;
            }
            try {
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource resource = resManager.createDirectly((Object)url, DrawableWrapper.class);
                return resource.getResource();
            }
            catch (ResourceException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Error while loading the drawable from " + url), (Throwable)e);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Error while loading the drawable from " + url + ": " + e.getMessage()));
                }
                this.failureCache.add(urlString);
                return null;
            }
        }
        if (o instanceof byte[]) {
            try {
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource resource = resManager.createDirectly(o, DrawableWrapper.class);
                return resource.getResource();
            }
            catch (ResourceException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Error while loading the drawable from byte[]", (Throwable)e);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Error while loading the drawable from byte[]: " + e.getMessage()));
                }
                return null;
            }
        }
        if (o instanceof Blob) {
            try {
                Blob b = (Blob)o;
                byte[] data = b.getBytes(1L, (int)b.length());
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource resource = resManager.createDirectly((Object)data, DrawableWrapper.class);
                return resource.getResource();
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)"Error while loading the drawable from an blob", (Throwable)e);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Error while loading the drawable from an blob: " + e));
                }
                return null;
            }
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.source = ds;
    }

    public Object clone() throws CloneNotSupportedException {
        DrawableLoadFilter il = (DrawableLoadFilter)super.clone();
        il.failureCache = (HashSet)this.failureCache.clone();
        if (this.source != null) {
            il.source = (DataSource)this.source.clone();
        }
        return il;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.failureCache = new HashSet();
    }
}

