/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.Format;
import java.text.ParseException;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class FormatParser
implements DataFilter {
    private Format format;
    private DataSource datasource;
    private Object nullvalue;

    public void setFormatter(Format format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.format = format;
    }

    public Format getFormatter() {
        return this.format;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Format f = this.getFormatter();
        if (f == null) {
            return this.getNullValue();
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this.getNullValue();
        }
        Object o = ds.getValue(runtime, element);
        if (o == null) {
            return this.getNullValue();
        }
        if (this.isValidOutput(o)) {
            return o;
        }
        try {
            return f.parseObject(String.valueOf(o));
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected boolean isValidOutput(Object o) {
        return false;
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.datasource = ds;
    }

    public void setNullValue(Object nullvalue) {
        this.nullvalue = nullvalue;
    }

    public Object getNullValue() {
        return this.nullvalue;
    }

    public Object clone() throws CloneNotSupportedException {
        FormatParser p = (FormatParser)super.clone();
        if (this.datasource != null) {
            p.datasource = (DataSource)this.datasource.clone();
        }
        if (this.format != null) {
            p.format = (Format)this.format.clone();
        }
        return p;
    }
}

