/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.sql.Blob;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ImageLoadFilter
implements DataFilter {
    private static final Log logger = LogFactory.getLog(ImageLoadFilter.class);
    private transient HashSet failureCache = new HashSet();
    private DataSource source;

    public ImageLoadFilter() {
        this(10);
    }

    public ImageLoadFilter(int cacheSize) {
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue(runtime, element);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            try {
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource resource = resManager.createDirectly(o, Image.class);
                return new DefaultImageReference(resource);
            }
            catch (ResourceException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Error while loading the image from a blob", (Throwable)e);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Error while loading the image from a blob: " + e.getMessage()));
                }
                return null;
            }
        }
        if (o instanceof Blob) {
            try {
                Blob b = (Blob)o;
                byte[] data = IOUtils.getInstance().readBlob(b);
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource resource = resManager.createDirectly((Object)data, Image.class);
                return new DefaultImageReference(resource);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Error while loading the image from a blob", (Throwable)e);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Error while loading the image from a blob: " + e.getMessage()));
                }
                return null;
            }
        }
        if (o instanceof URL) {
            URL url = (URL)o;
            String urlText = String.valueOf(url);
            if (this.failureCache.contains(urlText)) {
                return null;
            }
            try {
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource resource = resManager.createDirectly((Object)url, Image.class);
                return new DefaultImageReference(resource);
            }
            catch (ResourceException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Error while loading the image from " + url), (Throwable)e);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Error while loading the image from " + url + ": " + e.getMessage()));
                }
                this.failureCache.add(urlText);
                return null;
            }
        }
        if (o instanceof Image) {
            return o;
        }
        if (o instanceof ImageContainer) {
            return o;
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.source;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.source = ds;
    }

    public Object clone() throws CloneNotSupportedException {
        ImageLoadFilter il = (ImageLoadFilter)super.clone();
        if (this.source != null) {
            il.source = (DataSource)this.source.clone();
        }
        return il;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.failureCache = new HashSet();
    }
}

