/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.awt.Image;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class ImageRefFilter
implements DataFilter {
    private static final Log logger = LogFactory.getLog(ImageRefFilter.class);
    private DataSource dataSource;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return null;
        }
        Object o = ds.getValue(runtime, element);
        if (o instanceof ImageContainer) {
            return o;
        }
        if (o == null || !(o instanceof Image)) {
            return null;
        }
        try {
            return new DefaultImageReference((Image)o);
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to fully load a given image.", (Throwable)e);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ImageRefFilter r = (ImageRefFilter)super.clone();
        if (this.dataSource != null) {
            r.dataSource = (DataSource)this.dataSource.clone();
        }
        return r;
    }
}

