/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public class MessageFormatSupport
implements Serializable,
Cloneable {
    private static final Log logger = LogFactory.getLog(MessageFormatSupport.class);
    private static final String[] EMPTY_FIELDS = new String[0];
    private String[] fields;
    private FastMessageFormat format;
    private String formatString;
    private String compiledFormat;
    private String nullString;
    private transient Locale locale;
    private transient Object[] parameters;
    private transient Object[] oldParameters;
    private String cachedValue;

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        if (formatString == null) {
            throw new NullPointerException("Format must not be null");
        }
        if (ObjectUtilities.equal((Object)formatString, (Object)this.formatString)) {
            return;
        }
        MessageCompiler compiler = new MessageCompiler();
        this.compiledFormat = compiler.translateAndLookup(formatString);
        this.fields = compiler.getFields();
        if (this.fields.length > 0) {
            this.format = new FastMessageFormat(this.compiledFormat);
            if (this.nullString != null) {
                this.format.setNullString(this.nullString);
            }
        } else {
            this.format = null;
        }
        this.formatString = formatString;
        this.parameters = null;
        this.oldParameters = null;
        this.cachedValue = null;
    }

    public String performFormat(DataRow dataRow) {
        if (this.fields == null) {
            return null;
        }
        if (this.fields.length == 0) {
            return this.formatString;
        }
        if (this.parameters == null) {
            this.parameters = new Object[this.fields.length];
        }
        int parameterCount = this.parameters.length;
        if (this.oldParameters == null) {
            this.oldParameters = new Object[this.fields.length];
        } else {
            System.arraycopy(this.parameters, 0, this.oldParameters, 0, parameterCount);
        }
        for (int i = 0; i < this.fields.length; ++i) {
            String field = this.fields[i];
            Object o = dataRow.get(field);
            this.parameters[i] = o instanceof Number ? o : (o instanceof Date ? o : ElementTypeUtils.toString(o));
        }
        if (this.cachedValue != null && Arrays.equals(this.parameters, this.oldParameters)) {
            return this.cachedValue;
        }
        this.cachedValue = this.format.format((Object)this.parameters);
        return this.cachedValue;
    }

    public String getCompiledFormat() {
        return this.compiledFormat;
    }

    public Locale getLocale() {
        return this.format.getLocale();
    }

    public void setLocale(Locale locale) {
        if (ObjectUtilities.equal((Object)locale, (Object)this.locale)) {
            return;
        }
        this.locale = locale;
        if (this.format != null) {
            this.format.setLocale(locale);
        }
        this.parameters = null;
        this.oldParameters = null;
        this.cachedValue = null;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        if (!ObjectUtilities.equal((Object)nullString, (Object)this.nullString)) {
            this.nullString = nullString;
            if (this.format != null) {
                this.format.setNullString(nullString);
            }
            this.oldParameters = null;
            this.cachedValue = null;
        }
    }

    public String[] getFields() {
        if (this.fields == null) {
            return EMPTY_FIELDS;
        }
        return (String[])this.fields.clone();
    }

    public Object clone() throws CloneNotSupportedException {
        MessageFormatSupport support = (MessageFormatSupport)super.clone();
        if (this.format != null) {
            support.format = (FastMessageFormat)this.format.clone();
        }
        if (this.parameters != null) {
            support.parameters = (Object[])this.parameters.clone();
        }
        this.oldParameters = null;
        this.cachedValue = null;
        return support;
    }

    protected static class MessageCompiler
    extends PropertyLookupParser {
        private ArrayList fields = new ArrayList();

        protected MessageCompiler() {
            this.setMarkerChar('$');
            this.setOpeningBraceChar('(');
            this.setClosingBraceChar(')');
        }

        protected String lookupVariable(String name) {
            CSVTokenizer tokenizer = new CSVTokenizer(name, false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String varName = tokenizer.nextToken();
            StringBuilder b = new StringBuilder(name.length());
            b.append('{');
            b.append(String.valueOf(this.fields.size()));
            while (tokenizer.hasMoreTokens()) {
                b.append(',');
                b.append(tokenizer.nextToken());
            }
            b.append('}');
            String formatString = b.toString();
            this.fields.add(varName);
            return formatString;
        }

        public String[] getFields() {
            return this.fields.toArray(new String[this.fields.size()]);
        }
    }
}

