/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class ResourceFileFilter
implements DataFilter {
    private static final Log logger = LogFactory.getLog(ResourceFileFilter.class);
    private String resourceIdentifier;
    private DataSource dataSource;

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public void setResourceIdentifier(String resourceIdentifier) {
        this.resourceIdentifier = resourceIdentifier;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (this.dataSource == null) {
            return null;
        }
        if (runtime == null) {
            return null;
        }
        Object value = this.dataSource.getValue(runtime, element);
        if (value == null) {
            return null;
        }
        String svalue = String.valueOf(value);
        try {
            String resourceId = this.resourceIdentifier != null ? this.resourceIdentifier : runtime.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ResourceBundle");
            if (resourceId == null) {
                return null;
            }
            ResourceBundleFactory resourceBundleFactory = runtime.getResourceBundleFactory();
            ResourceBundle bundle = resourceBundleFactory.getResourceBundle(resourceId);
            if (bundle != null) {
                return bundle.getObject(svalue);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to retrive the value for key " + svalue));
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        ResourceFileFilter filter = (ResourceFileFilter)super.clone();
        filter.dataSource = (DataSource)this.dataSource.clone();
        return filter;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }
}

