/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.text.DateFormatSymbols;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DateFormatParser;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class SimpleDateFormatParser
extends DateFormatParser {
    private Locale lastLocale;
    private boolean keepState;

    public SimpleDateFormatParser() {
        this.setFormatter(new SimpleDateFormat());
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return (SimpleDateFormat)this.getFormatter();
    }

    public void setSimpleDateFormat(SimpleDateFormat format) {
        super.setFormatter(format);
    }

    public void setFormatter(Format format) {
        SimpleDateFormat sdfmt = (SimpleDateFormat)format;
        super.setFormatter(sdfmt);
    }

    public String getFormatString() {
        return this.getSimpleDateFormat().toPattern();
    }

    public void setFormatString(String format) {
        this.getSimpleDateFormat().applyPattern(format);
    }

    public String getLocalizedFormatString() {
        return this.getSimpleDateFormat().toLocalizedPattern();
    }

    public void setLocalizedFormatString(String format) {
        this.getSimpleDateFormat().applyLocalizedPattern(format);
    }

    public boolean isKeepState() {
        return this.keepState;
    }

    public void setKeepState(boolean keepState) {
        this.keepState = keepState;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Locale locale;
        if (!this.keepState && runtime != null && (locale = runtime.getResourceBundleFactory().getLocale()) != null && !locale.equals(this.lastLocale)) {
            this.lastLocale = locale;
            this.getSimpleDateFormat().setDateFormatSymbols(new DateFormatSymbols(locale));
        }
        return super.getValue(runtime, element);
    }
}

