/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataFilter;
import org.pentaho.reporting.engine.classic.core.filter.DataSource;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class URLFilter
implements DataFilter {
    private static final Log logger = LogFactory.getLog(URLFilter.class);
    private DataSource source;
    private URL baseURL;

    public DataSource getDataSource() {
        return this.source;
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.source = ds;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (this.getDataSource() == null) {
            return null;
        }
        Object o = this.getDataSource().getValue(runtime, element);
        if (o == null) {
            return null;
        }
        if (o instanceof URL) {
            return o;
        }
        try {
            if (o instanceof File) {
                File f = (File)o;
                if (f.canRead()) {
                    return f.toURL();
                }
            } else if (o instanceof String) {
                if (this.getBaseURL() == null) {
                    return new URL((String)o);
                }
                return new URL(this.getBaseURL(), (String)o);
            }
        }
        catch (MalformedURLException mfe) {
            logger.info((Object)"URLFilter.getValue(): MalformedURLException!");
        }
        return null;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public Object clone() throws CloneNotSupportedException {
        URLFilter f = (URLFilter)super.clone();
        if (this.source != null) {
            f.source = (DataSource)this.source.clone();
        }
        return f;
    }
}

