/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.templates;

import java.text.DecimalFormat;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.DataRowDataSource;
import org.pentaho.reporting.engine.classic.core.filter.DecimalFormatFilter;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.filter.StringFilter;
import org.pentaho.reporting.engine.classic.core.filter.templates.AbstractTemplate;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;

public class NumberFieldTemplate
extends AbstractTemplate
implements RawDataSource {
    private DecimalFormatFilter decimalFormatFilter;
    private DataRowDataSource dataRowDataSource = new DataRowDataSource();
    private StringFilter stringFilter;

    public NumberFieldTemplate() {
        this.decimalFormatFilter = new DecimalFormatFilter();
        this.decimalFormatFilter.setDataSource(this.dataRowDataSource);
        this.stringFilter = new StringFilter();
        this.stringFilter.setDataSource(this.decimalFormatFilter);
    }

    public DecimalFormat getDecimalFormat() {
        return (DecimalFormat)this.decimalFormatFilter.getFormatter();
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormatFilter.setFormatter(decimalFormat);
    }

    public String getFormat() {
        return this.decimalFormatFilter.getFormatString();
    }

    public void setFormat(String format) {
        this.decimalFormatFilter.setFormatString(format);
    }

    public String getField() {
        return this.dataRowDataSource.getDataSourceColumnName();
    }

    public void setField(String field) {
        this.dataRowDataSource.setDataSourceColumnName(field);
    }

    public String getFormula() {
        return this.dataRowDataSource.getFormula();
    }

    public void setFormula(String formula) {
        this.dataRowDataSource.setFormula(formula);
    }

    public String getNullValue() {
        return this.stringFilter.getNullValue();
    }

    public void setNullValue(String nullValue) {
        this.stringFilter.setNullValue(nullValue);
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        return this.stringFilter.getValue(runtime, element);
    }

    public Object clone() throws CloneNotSupportedException {
        NumberFieldTemplate template = (NumberFieldTemplate)super.clone();
        template.stringFilter = (StringFilter)this.stringFilter.clone();
        template.decimalFormatFilter = (DecimalFormatFilter)template.stringFilter.getDataSource();
        template.dataRowDataSource = (DataRowDataSource)template.decimalFormatFilter.getDataSource();
        return template;
    }

    protected DataRowDataSource getDataRowDataSource() {
        return this.dataRowDataSource;
    }

    public Object getRawValue(ExpressionRuntime runtime, Element element) {
        return this.decimalFormatFilter.getRawValue(runtime, element);
    }

    public FormatSpecification getFormatString(ExpressionRuntime runtime, Element element, FormatSpecification formatSpecification) {
        return this.decimalFormatFilter.getFormatString(runtime, element, formatSpecification);
    }
}

