/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;

public class ContentFieldType
extends ContentType {
    private transient ElementMetaData elementType;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("content-field");
        }
        return this.elementType;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue != null) {
            return staticValue;
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Object filteredValue;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object value = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (value != null && (filteredValue = this.filter(runtime, element, value)) != null) {
            return filteredValue;
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        return this.filter(runtime, element, nullValue);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

