/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.awt.Component;
import java.awt.Image;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.util.Locale;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ComponentDrawable;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawableImage;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class ContentType
implements ElementType {
    public static final ElementType INSTANCE = new ContentType();
    private transient LFUMap failureCache;
    private transient JFrame frame;
    private static final Class[] TARGETS = new Class[]{DrawableWrapper.class, Image.class};
    private static final Log logger = LogFactory.getLog(ContentType.class);
    private transient ElementMetaData elementType;

    public Object getValue(ExpressionRuntime runtime, Element element) {
        Object loadedNullValue;
        Object nullValue;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        URL resource = null;
        Object value = ElementTypeUtils.queryStaticValue(element);
        if (value != null) {
            Object filteredValue = this.filter(runtime, element, value);
            if (filteredValue != null) {
                return filteredValue;
            }
            boolean isBrokenImageEnabled = "true".equals(runtime.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.EnableBrokenImage"));
            if (isBrokenImageEnabled) {
                resource = ContentType.class.getResource("/org/pentaho/reporting/engine/classic/core/metadata/icons/image_broken_50.png");
            }
        }
        if ((nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value")) != null && (loadedNullValue = this.filter(runtime, element, nullValue)) != null) {
            return loadedNullValue;
        }
        try {
            if (resource == null) {
                resource = ContentType.class.getResource("/org/pentaho/reporting/engine/classic/core/metadata/icons/image_50.png");
            }
            if (resource != null) {
                ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
                Resource loadedResource = resManager.createDirectly((Object)resource, Image.class);
                Image image = (Image)loadedResource.getResource();
                return new ReportDrawableImage(image);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to load content." + e));
        }
        return value;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        return this.getValue(runtime, element);
    }

    protected Object filter(ExpressionRuntime runtime, Element element, Object value) {
        Object o;
        if (value == null) {
            return null;
        }
        if (value instanceof Image) {
            try {
                return new DefaultImageReference((Image)value);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to load content using value " + value), (Throwable)e);
                return null;
            }
        }
        if (value instanceof Shape) {
            return value;
        }
        if (value instanceof ImageContainer) {
            return value;
        }
        if (value instanceof Component) {
            Component c = (Component)value;
            return new DrawableWrapper((Object)this.createComponentDrawable(runtime, c));
        }
        if (value instanceof DrawableWrapper) {
            return value;
        }
        if (DrawableWrapper.isDrawable((Object)value)) {
            return new DrawableWrapper(value);
        }
        if (this.failureCache != null && Boolean.TRUE.equals(o = this.failureCache.get(value))) {
            return null;
        }
        try {
            ResourceKey key;
            ResourceKey contentBase = runtime.getProcessingContext().getContentBase();
            ResourceManager resManager = runtime.getProcessingContext().getResourceManager();
            if (value instanceof ResourceKey) {
                key = (ResourceKey)value;
            } else if (value instanceof Blob) {
                Blob b = (Blob)value;
                byte[] data = IOUtils.getInstance().readBlob(b);
                key = resManager.createKey((Object)data);
            } else if (value instanceof String) {
                ResourceKey baseKey;
                Object baseURL = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "content-base");
                if (baseURL instanceof String) {
                    baseKey = this.createKeyFromString(resManager, null, (String)baseURL);
                    key = this.createKeyFromString(resManager, baseKey, (String)value);
                } else if (baseURL instanceof ResourceKey) {
                    baseKey = (ResourceKey)baseURL;
                    key = this.createKeyFromString(resManager, baseKey, (String)value);
                } else if (baseURL != null) {
                    baseKey = resManager.createKey(baseURL);
                    key = this.createKeyFromString(resManager, baseKey, (String)value);
                } else {
                    key = this.createKeyFromString(resManager, contentBase, (String)value);
                }
            } else {
                key = resManager.createKey(value);
            }
            if (key == null) {
                return null;
            }
            Resource resource = resManager.create(key, contentBase, TARGETS);
            Object resourceContent = resource.getResource();
            if (resourceContent instanceof DrawableWrapper) {
                return resourceContent;
            }
            if (DrawableWrapper.isDrawable((Object)resourceContent)) {
                return new DrawableWrapper(resourceContent);
            }
            if (resourceContent instanceof Image) {
                return new DefaultImageReference(resource);
            }
            return resourceContent;
        }
        catch (Exception e) {
            if (this.failureCache == null) {
                this.failureCache = new LFUMap(5);
            }
            this.failureCache.put(value, (Object)Boolean.TRUE);
            logger.warn((Object)("Failed to load content using value " + value), (Throwable)e);
            return null;
        }
    }

    protected final ComponentDrawable createComponentDrawable(ExpressionRuntime runtime, Component c) {
        ComponentDrawable cd;
        Configuration config = runtime.getConfiguration();
        String drawMode = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.ComponentDrawableMode", "shared");
        if ("private".equals(drawMode)) {
            cd = new ComponentDrawable();
        } else if ("synchronized".equals(drawMode)) {
            cd = new ComponentDrawable();
            cd.setPaintSynchronized(true);
        } else {
            if (this.frame == null) {
                this.frame = new JFrame();
            }
            cd = new ComponentDrawable(this.frame);
            cd.setPaintSynchronized(true);
        }
        String allowOwnPeer = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.AllowOwnPeerForComponentDrawable");
        cd.setAllowOwnPeer("true".equals(allowOwnPeer));
        cd.setComponent(c);
        return cd;
    }

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("content");
        }
        return this.elementType;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
        element.getStyle().setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, Boolean.TRUE);
        element.getStyle().setStyleProperty(ElementStyleKeys.SCALE, Boolean.TRUE);
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(50.0f));
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, new Float(50.0f));
    }

    private ResourceKey createKeyFromString(ResourceManager resourceManager, ResourceKey contextKey, String file) {
        try {
            if (contextKey != null) {
                return resourceManager.deriveKey(contextKey, file);
            }
        }
        catch (ResourceException re) {
            logger.debug((Object)"Failed to load datasource as derived path: ", (Throwable)re);
        }
        try {
            return resourceManager.createKey((Object)new URL(file));
        }
        catch (ResourceException re) {
            logger.debug((Object)"Failed to load datasource as URL: ", (Throwable)re);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            return resourceManager.createKey((Object)new File(file));
        }
        catch (ResourceException re) {
            logger.debug((Object)"Failed to load datasource as file: ", (Throwable)re);
            return null;
        }
    }
}

