/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.filter.FormatSpecification;
import org.pentaho.reporting.engine.classic.core.filter.RawDataSource;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DateFieldType
implements ElementType,
RawDataSource {
    private transient ElementMetaData elementType;
    private transient SimpleDateFormat dateFormat;
    private transient Locale locale;
    private transient String formatString;
    private transient TimeZone timeZone;

    public ElementMetaData getMetaData() {
        if (this.elementType == null) {
            this.elementType = ElementTypeRegistry.getInstance().getElementType("date-field");
        }
        return this.elementType;
    }

    public Object getDesignValue(ExpressionRuntime runtime, Element element) {
        Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
        Object staticValue = ElementTypeUtils.queryStaticValue(element);
        if (staticValue instanceof Date) {
            if (formatStringRaw == null) {
                formatStringRaw = "EEE MMM dd HH:mm:ss zzz yyyy";
            }
            Locale locale = runtime.getResourceBundleFactory().getLocale();
            TimeZone timeZone = runtime.getResourceBundleFactory().getTimeZone();
            SimpleDateFormat dateFormat = new SimpleDateFormat(String.valueOf(formatStringRaw), locale);
            dateFormat.setDateFormatSymbols(new DateFormatSymbols(locale));
            dateFormat.setTimeZone(timeZone);
            return dateFormat.format(staticValue);
        }
        return ElementTypeUtils.queryFieldName(element);
    }

    public Object getRawValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Date)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        return retval;
    }

    public FormatSpecification getFormatString(ExpressionRuntime runtime, Element element, FormatSpecification formatSpecification) {
        Object formatStringRaw;
        if (formatSpecification == null) {
            formatSpecification = new FormatSpecification();
        }
        if ((formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string")) == null) {
            formatSpecification.redefine(1, "dd.MM.yyyy HH:mm:ss");
        } else {
            formatSpecification.redefine(1, String.valueOf(formatStringRaw));
        }
        return formatSpecification;
    }

    public Object getValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object retval = ElementTypeUtils.queryFieldOrValue(runtime, element);
        if (!(retval instanceof Date)) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
        Object formatStringRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string");
        if (formatStringRaw == null) {
            formatStringRaw = "EEE MMM dd HH:mm:ss zzz yyyy";
        }
        try {
            Locale locale = runtime.getResourceBundleFactory().getLocale();
            TimeZone timeZone = runtime.getResourceBundleFactory().getTimeZone();
            if (this.dateFormat == null) {
                this.formatString = String.valueOf(formatStringRaw);
                this.locale = locale;
                this.timeZone = timeZone;
                this.dateFormat = new SimpleDateFormat(this.formatString, locale);
                this.dateFormat.setDateFormatSymbols(new DateFormatSymbols(locale));
                this.dateFormat.setTimeZone(timeZone);
            } else {
                if (!ObjectUtilities.equal((Object)this.formatString, (Object)formatStringRaw)) {
                    this.formatString = String.valueOf(formatStringRaw);
                    this.dateFormat.applyPattern(this.formatString);
                }
                if (!ObjectUtilities.equal((Object)this.locale, (Object)locale)) {
                    this.locale = locale;
                    this.dateFormat.setDateFormatSymbols(new DateFormatSymbols(locale));
                }
                if (!ObjectUtilities.equal((Object)this.timeZone, (Object)timeZone)) {
                    this.timeZone = timeZone;
                    this.dateFormat.setTimeZone(timeZone);
                }
            }
            return this.dateFormat.format(retval);
        }
        catch (Exception e) {
            return element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DateFieldType o = (DateFieldType)super.clone();
        if (o.dateFormat != null) {
            o.dateFormat = (SimpleDateFormat)this.dateFormat.clone();
        }
        return o;
    }

    public void configureDesignTimeDefaults(Element element, Locale locale) {
    }
}

