/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.filter.types;

import java.math.BigDecimal;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class ElementTypeUtils {
    private static final Number[] EMPTY_NUMBERS = new Number[0];

    private ElementTypeUtils() {
    }

    public static Object queryFieldName(Element element) {
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (attribute != null) {
            return attribute;
        }
        return null;
    }

    public static Object queryStaticValue(Element element) {
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object attribute = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
        if (attribute != null) {
            return attribute;
        }
        return null;
    }

    public static Object queryFieldOrValue(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object value = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
        if (value != null) {
            return value;
        }
        Object field = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field");
        if (field != null) {
            return runtime.getDataRow().get(String.valueOf(field));
        }
        return null;
    }

    public static String queryResourceId(ExpressionRuntime runtime, Element element) {
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object resourceId = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-identifier");
        if (resourceId != null) {
            return String.valueOf(resourceId);
        }
        return runtime.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.ResourceBundle");
    }

    public static String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            try {
                return IOUtils.getInstance().readClob(clob);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (object.getClass().isArray()) {
            if (object instanceof char[]) {
                return new String((char[])object);
            }
            if (object instanceof Object[]) {
                StringBuilder b = new StringBuilder();
                Object[] array = (Object[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(ElementTypeUtils.toString(array[i]));
                }
                return b.toString();
            }
            if (object instanceof byte[]) {
                StringBuilder b = new StringBuilder();
                byte[] array = (byte[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(array[i]);
                }
                return b.toString();
            }
            if (object instanceof short[]) {
                StringBuilder b = new StringBuilder();
                short[] array = (short[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(array[i]);
                }
                return b.toString();
            }
            if (object instanceof boolean[]) {
                StringBuilder b = new StringBuilder();
                boolean[] array = (boolean[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(array[i]);
                }
                return b.toString();
            }
            if (object instanceof int[]) {
                StringBuilder b = new StringBuilder();
                int[] array = (int[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(array[i]);
                }
                return b.toString();
            }
            if (object instanceof long[]) {
                StringBuilder b = new StringBuilder();
                long[] array = (long[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(array[i]);
                }
                return b.toString();
            }
            if (object instanceof float[]) {
                StringBuilder b = new StringBuilder();
                float[] array = (float[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(array[i]);
                }
                return b.toString();
            }
            if (object instanceof double[]) {
                StringBuilder b = new StringBuilder();
                double[] array = (double[])object;
                for (int i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(", ");
                    }
                    b.append(array[i]);
                }
                return b.toString();
            }
        }
        return String.valueOf(object);
    }

    public static Number getNumberAttribute(Element e, String namespace, String name, Number defaultValue) {
        Object val = e.getAttribute(namespace, name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            return (Number)val;
        }
        return defaultValue;
    }

    public static int getIntAttribute(Element e, String namespace, String name, int defaultValue) {
        Object val = e.getAttribute(namespace, name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Number) {
            Number nval = (Number)val;
            return nval.intValue();
        }
        return ParserUtil.parseInt((String)String.valueOf(val), (int)defaultValue);
    }

    public static boolean getBooleanAttribute(Element e, String namespace, String name, boolean defaultValue) {
        Object val = e.getAttribute(namespace, name);
        if (val == null) {
            return defaultValue;
        }
        if (val instanceof Boolean) {
            Boolean nval = (Boolean)val;
            return nval;
        }
        return ParserUtil.parseBoolean((String)String.valueOf(val), (boolean)defaultValue);
    }

    public static Number[] getData(Object o) {
        ArrayList<Object> numbers = new ArrayList<Object>();
        try {
            if (o instanceof ArrayCallback) {
                ArrayCallback acb = (ArrayCallback)o;
                int rowCount = acb.getRowCount();
                int colCount = acb.getColumnCount();
                for (int row = 0; row < rowCount; ++row) {
                    for (int column = 0; column < colCount; ++column) {
                        numbers.add(acb.getValue(row, column));
                    }
                }
                return numbers.toArray(new Number[numbers.size()]);
            }
            if (o instanceof List) {
                List l = (List)o;
                for (int i = 0; i < l.size(); ++i) {
                    Object value = l.get(i);
                    if (value instanceof Number) {
                        numbers.add(value);
                        continue;
                    }
                    if (!(value instanceof String)) continue;
                    numbers.add(new Float((String)value));
                }
                return numbers.toArray(new Number[numbers.size()]);
            }
            if (o instanceof Object[]) {
                Object[] l = (Object[])o;
                ElementTypeUtils.arrayToList(numbers, l);
                return numbers.toArray(new Number[numbers.size()]);
            }
            if (o instanceof String) {
                return ElementTypeUtils.toBigDecimalList((String)o, ",");
            }
            if (o instanceof Number) {
                numbers.add(o);
                return numbers.toArray(new Number[numbers.size()]);
            }
        }
        catch (NumberFormatException nfe) {
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        return null;
    }

    private static void arrayToList(ArrayList numbers, Object[] l) {
        for (int i = 0; i < l.length; ++i) {
            Object value = l[i];
            if (value instanceof Number) {
                numbers.add(value);
                continue;
            }
            if (value instanceof String) {
                numbers.add(new BigDecimal((String)value));
                continue;
            }
            if (!(value instanceof Object[])) continue;
            Object[] innerArray = (Object[])value;
            ElementTypeUtils.arrayToList(numbers, innerArray);
        }
    }

    private static Number[] toBigDecimalList(String s, String sep) {
        if (StringUtils.isEmpty((String)s)) {
            return EMPTY_NUMBERS;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(s, sep);
        Number[] ret = new Number[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String val = stringTokenizer.nextToken().trim();
            ret[i] = new BigDecimal(val);
            ++i;
        }
        return ret;
    }
}

